##Day 3: Murder
# John (as Tori) takes the possessed body of Kiyoshi (in the body of Yui) to Setsuna to have it exorcised. There he learns of the murder from the ghost/Setsuna.
#
# Until murder is solved, Setsuna will be possessed. The two return home, deciding to investigate it the next day.

label legacy_alien_murder_day3:
    resetstate

    "This is the Murder Mystery route. It was the very first route in Student Transfer."
    "It was a shared route. Each developer wrote a specific scene and it was all stiched together afterward. We didn't really know what we were doing, so that sounded like a fair way to go about it."
    "The results were mixed. It had inconsistencies, wacky characterization, and plot holes."
    "Ultimately, there were issues that made it incompatible with the rest of the game, such as breaking the rules of the setting in order to progress the plot or making certain major characters nearly impossible to use in any other route."
    "For these reasons, it was removed from the game as of Version 4.0. As of Version 8.0, a new, revamped version of the route entered production and now occupies its place."
    "Nevertheless, the original was still fun to create, problems and all. It kicked off the game. It launched Student Transfer into a collaborative effort we're all proud of. Even now, we still have people asking about how they can access it."
    "For those reasons we have preserved it as a scenario, so that people can still enjoy it if they like."
    "So, without further ado..."

    play music bgm_airport_lounge
    scene bg school entrance day
    show kiyoshi a_0 at centerleft
    show john a_0 at centerright, faceleft
    with dissolve

    show john a_1 with exchange
    john "Truth be told, I was abducted by aliens."

    show kiyoshi a_5 with exchange
    kiyoshi "Huh?"

    show john a_6 with exchange
    john "I can't believe I'm saying this, but you did something right for once in your life. They thought it was a genius idea to make a crop circle in the park, thought I was responsible, and abducted me."

    show john a_13 with exchange
    john "I have proof, too."

    "I removed the device from my pocket."

    show john a_3 with exchange
    john "When I woke up this morning, I found this."

    show kiyoshi a_0 with exchange
    "Kiyoshi stared at the device for a few seconds."

    show john a_6 with exchange
    think "Will he buy it...?"

    show kiyoshi a_3 with exchange
    kiyoshi "John, that's..."

    show kiyoshi a_2 with exchange
    kiyoshi "{b}Amazing!{/b} What's it do!?"

    show john a_4 with exchange
    think "He... really believes me?"

    show john a_0 with exchange
    "Usually I'd call him an idiot for something like this, but... not today."

    john "Lots of things. It can switch people's bodies, rewrite their memories or personality, clone bodies... and a bunch of other stuff."

    show kiyoshi a_6 with exchange
    kiyoshi "Forget {q}amazing!{/q} That's... {i}incredible!{/i} Show me!"

    show john a_3 with exchange
    john "Well, I've been thinking. Yui's gonna chew us out for being so late, so..."

    stop music fadeout 2.0
    scene black
    with dissolve

    "We decided on a plan to test the device together. We'd tell her to forget whenever she saw us arriving late at school so we'd no longer have to hear her endless lectures on tardiness. The plan seemed perfect."

    scene bg school hallway_1 day
    show john a_0 at Position(pos=(0.7, 1.0), anchor=(0.5, 1.0))
    show kiyoshi a_1 at Position(pos=(0.5, 1.0), anchor=(0.5, 1.0))
    with dissolve
    play sound sfx_knock
    "We knocked on the door to our first class of the day."

    play sound sfx_sliding_door_close
    show bg school hallway_1 day_open with dissolve

    pause 0.2
    show john:
        easein 0.5 xpos 0.4
    show kiyoshi:
        0.1
        easein 0.5 xpos 0.2
    show yui a_3 at centerright, faceleft behind john with dissolve
    show bg school hallway_1 day with dissolve

    "A few seconds later, out stormed Yui."

    show john:
        xpos 0.4
    show kiyoshi:
        xpos 0.2
    show yui a_2 with exchange
    yui "John! Kiyoshi! The two of you are super late!"

    show john a_3 with exchange
    play music bgm_dreams_become_real
    "But this time, we had a plan."

    show yui b_3 with exchange
    play sound sfx_device
    show expression alien_particles(400, 200, 220, mind_scale) as particles:
        xpos placement_of(yui).xpos + 0.0400
        ypos 0.32
        alien_particles_fadeinout(0.75)

    yui "Ah..."

    "Immediately she became silent and looked dazed somehow, staring blankly into space."

    john "Okay, now let's make her for--{w=0.5}{nw}"

    play music bgm_investigations
    kiyoshi "Yui, you're hereby ordered to take it easy from now on!"

    show john a_8 with exchange
    think "So much for the plan."

    kiyoshi "Be more relaxed! Don't sweat the small stuff, stuff like being late! In the long run, that kind of thing doesn't really matter, does it?"

    john "Don't you think that's a little too general, Kiyoshi?"

    show kiyoshi a_2 with exchange
    kiyoshi "No way, dude! It'll be fine! Trust me."

    john "Well..."

    show kiyoshi a_1 with exchange
    "Yui was still staring ahead with that zombie-like look on her face."

    john "Anyway, I guess we should get her out of that hypnotic state and see what happens."

    show kiyoshi a_6 with exchange
    kiyoshi "I kinda prefer her like this. Do you think we could--"

    show john a_5 with exchange
    show kiyoshi a_0 with exchange
    john "{b}No.{/b}"

    show john a_8 with exchange
    show yui a_7 with exchange
    "I released control of her and she looked at us like someone coming out of a deep sleep."

    show yui a_0 with exchange
    yui "Oh, you two are late again, right? Well, it's only ten minutes, so no biggie. Just make sure you get to class sooner next time."
    yui "Or not. Whatever floats your boat."

    play sound sfx_sliding_door_open
    show yui at faceright with exchange
    show bg school hallway_1 day_open with dissolve

    hide yui with dissolve

    "Yui gave a big yawn and, slouching, re-entered the classroom. Kiyoshi was obviously pleased at the success of his vague command."

    stop music fadeout 2.0
    show john a_2 with exchange
    think "I really hope this doesn't cause her any serious problems..."

    "Kiyoshi seemed to notice my worried look."

    show kiyoshi a_1 with exchange
    kiyoshi "Everything'll be {i}fine.{/i} This is the best solution for everyone, I guarantee it! Just think of this as helping Yui take a long overdue vacation from being herself."

    show john a_2 with exchange
    john "Kiyoshi, that doesn't even make sense..."

    show kiyoshi:
        ease 0.8 xpos 0.8
    pause 0.8
    hide kiyoshi with dissolve

    "Disregarding me, Kiyoshi strolled leisurely ahead to class, humming an upbeat tune to himself. I stowed the device in my backpack and followed."

    scene bg school classroom_1
    with fade

    "Ms. Williams' class proceeded largely without incident, save an in-class announcement toward the end from the {q}new and improved{/q} Yui about our duty to keep the school clean."

    play music bgm_hidden_agenda
    yui "Oh, I had some kind of note here..."

    "Yui fumbled around her school uniform's pockets for it, and then returned to her seat and began rummaging through her backpack until finally pulling out a crumpled note. She then returned to the front of the class."

    yui "Yeah, I'm supposed to say the principal wants us to keep the school clean. She says there's been a lot of trash around lately. I don't remember it bothering me, but... yeah, anyway, just, you know, keep it in mind every... Where was I? Oh, right--"

    think "God, what has Kiyoshi done?"

    "Seeing Kiyoshi's monster in action and hearing the confused reactions from classmates ranging from {q}is this a joke?{/q} to {q}Yui must be on drugs,{/q} I couldn't help but feel a little embarrassed for her by proxy."

    stop music fadeout 2.0
    "Regardless, hearing that was better than hearing another lecture on punctuality."

    play sound sfx_bell noloop
    scene bg school cafeteria
    show john a_0 at centerleft
    show kiyoshi a_0 at centerright, faceleft
    with Fade(0.5, 1.0, 0.5)
    queue music bgm_vivacity

    "By lunch, the events that morning were bothering me less, though I was beginning to think changing Yui had become more trouble than it was worth."

    "I sat next to Kiyoshi who was picking up and examining each french fry as if it were a lab specimen and then biting into its middle and setting the tips aside."
    "I'd intended to bring up the subject of Yui with Kiyoshi, but, psychologically, he was on an entirely different plane of existence."

    show kiyoshi a_1 with exchange
    kiyoshi "Hey, John, I've been thinking..."
    kiyoshi "You know those rumors about ghosts haunting the girls' locker room? Stuff going missing, getting moved, girls seeing mysterious figures... and, heh, bras floating around... It's a huge mystery!"

    show john a_1 with exchange
    john "Ghosts don't exist. Mystery solved."

    show kiyoshi a_6 with exchange
    kiyoshi "You mean like aliens?"

    show john a_2 with exchange
    john "..."

    think "Well, he's got me there."

    show kiyoshi a_3 with exchange
    kiyoshi "C'mon, dude, with this device, we can investigate it! It's obviously worth checking out. If aliens can exist, so can ghosts."

    john "They're two complete--"

    kiyoshi "And it's a once in a lifetime opportunity to see how the other half lives! Haven't you always wondered how many personal masseuses work in the girls' locker room spa?"

    show john a_5 with exchange
    john "It's a number equal to the number of ghosts."

    show kiyoshi a_1 with exchange
    kiyoshi "Look, I have the perfect plan for getting us in and out with absolutely {i}no{/i} problems whatsoever. It's idiot-proof!"

    show john a_1 with exchange
    john "Then it's certain to fail."

    show kiyoshi a_3 with exchange
    kiyoshi "How do you know?"

    show john a_6 with exchange
    john "Because--"

    show kiyoshi a_5 with exchange
    kiyoshi "Pretty please?"

    "Although I was lukewarm to the idea because of the whole Yui situation, the idea still had a certain appeal. It did seem like it'd be fun. And, after all, I had the device, so why not use it a little for something besides avoiding a lecture?"

    "Yet I was much less sure about trusting Kiyoshi in any way with anything involving the device. At least any more than I already had."
    "I didn't think he would ever actually turn on me and take it for himself, but he {i}could{/i} use the device in a way that might create unintended side-effects, similar to what happened with Yui."

    menu:
        "Wavering between my choices, I finally decided..."

        "I'd investigate the locker rooms with Kiyoshi.":
            routename "Ghostbusters"

            show john a_6 with exchange
            john "Okay, let's do it. If only to prove you wrong."

            show kiyoshi a_6 with exchange
            kiyoshi "Cool! Let me make my... preparations. I will be with you shortly..."

            show kiyoshi:
                faceright
                easeout 0.4 offscreenright
            "Kiyoshi leapt from the table and sped off somewhere--who knows where--to {q}prepare{/q} himself for the investigation."

            hide kiyoshi
            show john a_4 with exchange
            john "Wait, you left your--"

            show john a_5 with exchange
            think "Lunch."

            "Kiyoshi disappeared from view before I could finish my words. I looked at his lunch tray, a tuber war zone littered with the yellow and white remains of many a fry, and sighed."

            think "I'm almost starting to think agreeing to his plan was a bad idea..."

            "I picked up all of our garbage, threw it away, and headed to the locker room."

            stop music fadeout 1.0
            jump legacy_alien_murder_day3_lockers

        "{s}It was best not to mess with anything else right now.{/s}":
            routename "Ghosts Don't Exist"
            placeholder

label legacy_alien_murder_day3_lockers:
    outfit tori gym
    outfit kiyoshi gym_female
    outfit yui gym

    scene bg school stairwell_1 day
    show tori a_0 at centerleft, faceleft
    with Fade(0.5, 1.0, 0.5)

    show john a_6 at centerright, faceleft behind tori with easeinright

    # micromegas: significant revision here; whole thing probably needs more revision and to be tested to see if the sprites, emotions, and so forth still match with the scene; kiyoshi's certainly doesn't at the start (his body's still yui's), but i don't know enough to change it to the right sprite

    "Approaching the girls' locker room, I saw Tori, the distaff face of our school's delinquents."

    think "Who'd have guessed she'd be trying to cut class..."

    play music bgm_anamalie
    show tori a_2 at faceright with exchange
    tori "What do {i}you{/i} want, fucking perv?"

    show john a_4 with exchange
    john "Whoa, you're pretty touchy today..."

    tori "And, what, you're hanging out around the girls' locker room because you're our knight in shining armor? Just {i}concerned{/i} for us? You're lucky I don't beat you up here and now."

    show john a_2 with exchange
    "Getting beaten up by Tori wasn't on my itinerary for the day. Her being here did give me an idea for what body I'd use to sneak into the girls' locker room, but I still had to get her to go away."

    john "Well, Yui asked me to scope out the locker rooms, just to make sure no one was lingering around."

    think "She knows our parents are friends, right? She should buy it..."

    john "Third period has already started, so I'll have to ask you to get to class."

    "From the look she gave me, I'd have done better to tell her I was searching for ghosts."

    show tori a_0 with exchange
    tori "Don't bullshit me."

    show tori at faceleft with exchange
    tori "Well, whatever. I need to get away from {i}her{/i} anyway."
    #Her is Tori, John thinks she means "Yui" though.

    stop music fadeout 2.0
    show tori:
        faceright
        linear 0.5 offscreenright
    play sound sfx_whack
    show john a_4:
        faceright
        easein 0.5 center
    with hpunch
    tori "Out of my way!"
    hide tori

    show john a_5 at center with exchange
    think "She must not like Yui much. Clearly no love lost there."

    play music bgm_dreams_become_real
    show john a_3 with exchange
    "With Tori some distance away, I drew out the device and pointed it at her, used the cloning function, and then used the device on myself."

    play sound sfx_device
    show expression alien_particles(1500, 340, 700) as particles:
        xpos placement_of(john).xpos
        ypos 0.6
        alien_particles_fadein
    morph begin alien john tori gym a_1
    "It was the first time I'd used the device on myself, and its most immediate effect was a sense of dislocation in my own body, and I began to notice myself changing little by little."
    "First, my hair, which had always been short, grew quickly as it expanded into a messy bun pinned together by strange things. Choppy locks of ash blonde trickled down from it, one large bang obscuring my left eye completely."
    "My legs and thighs filled out, becoming much rounder and softer. My ass did the same, plumping up and straining against the rear of the gym uniform I was now wearing."
    morph do john
    "The uniform itself became tattered, less like it was simply frayed and more as if a pack of wolves had gnawed on it. Her lack of a bra forced me to support her burdensome chest with my new arms as she often did, and I felt a breeze tickling the bottom of my stomach."
    "Lastly, I felt a bizarre sense of suction around my crotch as the front seemed to compensate for the back's new heft and became completely flat."
    morph end john
    hide particles with dissolve
    # micromegas: could always add more, but probably sufficient

    show john a_0 with exchange
    "For a few moments, my head was spinning. I tried my best to shake off the strange new smells and sensations to concentrate on the mission at hand."
    think "Now to find Kiyoshi."

    show john at centerleft:
        faceleft
    with ease
    "I took a step and felt parts of my body moving around I'd never felt before. I touched my breasts for a moment, my nipples tingling as I brushed past them with my fingers."
    show john a_2 blush with exchange
    think "..."
    "I closed my eyes and took a deep breath."
    think "Better not think about this, otherwise it'll be a hard slog until I change back..."
    show john a_0 blush:
        easeout 1.0 offscreenleft
    pause 1.0

    stop music fadeout 1.0
    scene bg school lockerroom
    with fade

    show john a_0 at left with easeinleft

    "I checked inside the girls' locker room. It seemed to be empty."

    think "Guess he's not in here."

    show john a_0 at centerleft with ease
    think "Where the hell could he--"

    # TODO: play heavy door SF
    "Just then, someone entered the room from the gym."

    show yui a_0 at right, faceleft with easeinright
    # micromegas: may need to play with yui's reactions here since dialogue changes

    # micromegas: might still need to emphasize feelings of guilt from morning a bit more, but this scene's end should work to fix the plot hole as it returns yui to normal
    yui "Oh, Tori, you're here..."

    think "Tori? Oh, right..."

    yui "You've kinda been here a lot this week. Skipping class or something?"

    john "Uh... I, um..."

    show yui a_6 with exchange
    yui "Huh?"

    "Yui looked at me quizzically."

    think "Ah, that's right. I should try to act like Tori."

    show john a_2 with exchange
    john "B-Bitch, I do what I want."

    think "...Is that the best I could come up with!?"

    show yui a_1 with exchange
    "Yui seemed to buy it, probably because of what we did to her earlier."

    yui "Well, you should, you know, like, have some kind of excuse from somewhere, shouldn't you? It doesn't bother me, but the principal wants me to check, so..."

    show john a_0 with exchange
    john "I do, actually. I've got... a huge fucking period right now."
    john "It's like the fuckin' Alamo in my pants right now. I'm gonna need, like, twenty fucking blood packs after this. Seriously, you're gonna want to keep your distance."

    show yui a_0 with exchange
    yui "I guess that works."

    "I'm not sure if Yui completely believed me, but, changed as she was, she looked like she didn't want to get involved."

    yui "I'll let you take care of that then."

    pause 1.0

    think "Yui really is in bad shape if she's willing to let this go. I can't let her stay this way."

    play sound sfx_device
    show expression alien_particles(400, 200, 220, mind_scale) as particles:
        xpos placement_of(yui).xpos + 0.01
        ypos 0.32
        alien_particles_fadeinout(0.75)
    show yui a_6 with exchange
    "I took out the device, pointed it at her, and pressed the personality button again."
    john "Yui, I command you to return to the way you were before the last command given to you... But don't do that until you get back to your next class."

    pause 0.5

    john "Oh, also..."

    play sound sfx_device
    hide particles
    show expression alien_particles(400, 250, 700) as particles:
        xpos placement_of(yui).xpos
        ypos 0.6
        alien_particles_fadeinout(0.5)
    "I pointed the device at her again and pressed the clone button to copy her form."

    john "That should be good for Kiyoshi."

    "I looked back up at Yui, staring out with deadened eyes."

    john "Alright, snap out of it."

    "Yui regained awareness with a confused but still placid expression on her face."

    show yui a_1 with exchange
    yui "Did something just happen?"

    john "Um, no--err, what're you talking about? Got shit between your ears or something?"

    show yui a_5 with exchange
    yui "No, sorry..."

    show yui:
        faceright
        easeout 0.8 offscreenright
    "Yui shook her head and left the room. I breathed out a sigh of relief when the double doors shut behind her."
    hide yui
    hide particles

    pause 1.0
    show john a_1 with exchange
    john "...This is pretty fun."

    "Just then, I heard someone open the door from behind me."

    show john a_0 at center, faceleft with ease
    show kiyoshi a_0 at left with easeinleft

    pause 1.0
    show kiyoshi a_5 with exchange
    kiyoshi "...O-Oh."
    show kiyoshi a_2 with exchange
    kiyoshi "H-Hey there, Tori."
    pause 1.0
    show kiyoshi a_5 with exchange
    kiyoshi "{b}P-Please don't kill me!{/b}"
    show john a_2 with exchange
    john "Keep your voice down, you idiot!"

    show john a_0 with exchange
    john "...Wait, what the fuck are you wearing?"

    kiyoshi "I, um, I didn't sneak in here before and steal this uniform or anything, if that's what you're asking!"

    john "Kiyoshi, it's {i}me,{/i} dumbass."
    show john a_0 with exchange
    "I held up the device in front of him."

    kiyoshi "...Oh."
    show kiyoshi a_3 with exchange
    kiyoshi "...B-But I mean what I said."

    play sound sfx_device
    show expression alien_particles(1500, 250, 700) as particles:
        xpos placement_of(kiyoshi).xpos
        ypos 0.6
        alien_particles_fadein
    morph begin alien kiyoshi yui gym a_0
    "I rolled my eyes and pressed the clone button on the device."

    morph finish kiyoshi
    hide particles with dissolve
    "Eyes wide, Kiyoshi stood there, stiff as a statue. Even his breathing seemed to stop."

    show kiyoshi a_2 blush with exchange
    kiyoshi "John?"

    kiyoshi "Why am I shorter than you, and... why does my voice feel squeaky coming out of my mouth?"

    "I was sure that Kiyoshi knew why, and was just in shock."

    show john a_1 with exchange
    john "Well, in case you forgot, I have a device that can change people, and for some stupid reason I decided to join you in a ghost hunt through the girls' locker room."

    kiyoshi "But why am I Yui?"

    john "I thought you'd make a perfect Yui since you're both enormous pains in the ass."

    show kiyoshi a_5 with exchange
    "Kiyoshi was looking at me a little bit hurt and I softened my tone."

    show john a_0 with exchange
    john "Sorry, the real Tori tore into me before I came in here."

    show kiyoshi a_0 with exchange
    kiyoshi "Nah, don't sweat it. Let's get started!"

    show kiyoshi a_0 blush with exchange
    "Kiyoshi gave a lewd smile and started to paw his own breast before I stopped him."

    show kiyoshi a_5 with exchange
    kiyoshi "Aww..."

    john "Where did you get that gym uniform anyway?"

    show kiyoshi a_0 with exchange
    kiyoshi "From my locker."

    john "You have a girls' gym uniform in your own locker?"

    show kiyoshi a_7 with exchange
    kiyoshi "Yep. Do you want to know how? I assure you, it's an interesting tale, one--"

    john "Look, the less I know about that, the better."

    show kiyoshi a_1 blush with exchange
    "Kiyoshi began staring down at his new breasts again. His hands were gravitating toward them."

    john "C'mon, we're supposed to be investigating ghosts, not boobs."

    kiyoshi "But aren't you curious?"

    john "...Maybe, but that's not why we came here."

    show kiyoshi a_7 blush with exchange
    kiyoshi "Come on, dude, can't we just take a little detour...?"

    "He winked at me as he said it."

    menu:
        "I knew where this was going. The thought of seeing Tori's naked body, and maybe Yui's while I was at it..."

        "{s}There was time for some {i}private investigations.{/i}{/s}":
            placeholder

        "I decided we'd do what we came here for.":
            routename "Close Encounters"

    john "We're here to investigate rumors about ghosts, Kiyoshi, not screw around in these bodies."

    show kiyoshi a_0 with exchange
    kiyoshi "Man, I didn't know you were such an avid ghost hunter! And just earlier you were saying they didn't exist... Well, just for you, let's get back to finding ghosts."

    "I slumped my shoulders, half-regretting my choice."

    think "I guess now I'm committed to go along with this {q}ghost hunting{/q} expedition..."
    stop music fadeout 2.0

    show kiyoshi a_1 with exchange
    kiyoshi "So. Let's begin the mission briefing."

    show screen ghost_hunt_briefing()
    play music bgm_ouroboros
    show kiyoshi a_3 with exchange
    kiyoshi "The girls' locker room is split into four major sections."
    kiyoshi "There's the main locker area in which we are standing; then there's the storeroom, there's the bathroom, and there's the office."
    kiyoshi "The office, as you can see, is completely visible through the glass panels, so no thorough investigation is needed there. Besides, the doors are always locked."
    kiyoshi "Fortunately, the storeroom doors are almost never locked, except on Saturdays."
    kiyoshi "Regarding the main area: there's a total of forty-eight lockers in the room. Each lock takes approximately... twelve seconds to jiggle open."

    show kiyoshi a_7 with exchange
    $ renpy.music.set_volume(0.1)
    kiyoshi "...I learned these things from a friend, of course."
    john "I see."

    $ renpy.music.set_volume(1.0)
    show kiyoshi a_3 with exchange
    kiyoshi "That gives us... six-hundred seconds, or ten minutes, for the lockers alone."
    kiyoshi "The storeroom is typically accessed approximately twenty minutes after class starts, so we have plenty of time there."
    kiyoshi "One of us will take point on the lockers while the other investigates the storeroom. By then, we'll have plenty of leftover time to investigate the bathroom as needed."
    stop music fadeout 0.5
    hide screen ghost_hunt_briefing
    show kiyoshi a_2 with exchange
    kiyoshi "Briefing concluded."

    play music bgm_groove_grove
    show kiyoshi a_0 with exchange
    "I considered my options."

    menu:
        "Looking through the girls' lockers felt like it was as much an invasion of privacy as cloning their bodies, if not more so. But it would probably be better if I was looking through them instead of someone like Kiyoshi."

        "{s}I decided I'd search the storeroom.{/s}":
            routename "Storage Surprise"
            placeholder

        "I decided I'd look through the lockers.":
            routename "Saint Max"

    john "I'll do the lockers. You do the storeroom."

    "I started searching around the lockers."

    show john at centerright, faceright with ease

    play sound sfx_knock
    john "...Any ghosts around?"

    show john at faceleft with exchange
    show kiyoshi a_3 with exchange
    "Kiyoshi gazed at me with a look of disappointment, clicking his tongue. I then made an exaggerated stance, with my arms wide out and above me."

    show john a_2 with exchange
    john "I exorcise all spooks in the name of Saint Max!"

    show kiyoshi a_1 with exchange
    "Kiyoshi, looking pleased, turned away and moved on."
    hide kiyoshi with dissolve

    show john a_0 with exchange
    think "I feel like an idiot, trying to exorcise the girls' locker room. At least it satisfied Kiyoshi..."

    scene bg school lockerroom
    show john a_0 at centerleft
    with Fade(0.5, 1.0, 0.5)

    "After finishing my brief search, I waited around for Kiyoshi."
    "I started inspecting my new body absentmindedly. Her strong arms and legs, the swell of her breasts beneath me--I hadn't gotten used to any of it."
    think "And nothing below either..."
    "As my hand was moving down, I was suddenly interrupted by a voice coming from the storeroom."

    stop music fadeout 2.0
    kiyoshi "Hey John, look what I found!"

    show kiyoshi a_0 at centerright, faceleft
    show faithGhost a_0 at right, faceleft
    with dissolve
    play music bgm_all_this

    john "Oh... my god."

    "Behind Kiyoshi floated what could only be described as an ethereal body."

    $ faith.name = "Ghost"
    faith "{size=+10}{b}{i}{k=+10}Go away!{/k}{/i}{/b}{/size}"

    "This was terrifying. The ramifications of her being there--an actual ghost!--were Earth-shattering."
    "So many questions on the nature of sin, the soul, and life after death filled my head."

    show kiyoshi a_7 at faceright with exchange
    kiyoshi "Hey, ghost lady! You're dead, right?"
    faith "Well, yes, but--{w=0.3}{nw}"

    play music bgm_monkeys_spinning_monkeys
    show kiyoshi a_1 with exchange
    kiyoshi "That's great because I've been {i}dying{/i} to meet you!"

    think "Christ, not more lines from that pun book again..."

    faith "...What?"

    show kiyoshi a_0 with exchange
    kiyoshi "Your love for me is clear. Yes, it's absolutely {i}transparent{/i} how you feel!"

    "The ghost stared passively at him."

    faith "I told you to{b}{i}{k=+10} go away.{/k}{/i}{/b}"
    faith "...Besides, I don't swing that way."

    john "Kiyoshi, please let's go!"

    show kiyoshi a_3 with exchange
    kiyoshi "No way! I've wanted to see a ghost for ages and now I finally meet one! I'm not afraid of her just because of what she looks like. We're soul mates!"

    faith "...That's actually a little touching."

    show kiyoshi a_0 with exchange
    kiyoshi "Yep! Speaking of touching, can I touch your boobs, or will my hand just pass through your body?"

    stop music
    "Both myself and the ghost glared at him."

    play music bgm_all_this
    faith "{b}{i}...You'll feel my wrath for that!{/i}{/b}"

    show kiyoshi a_6 with exchange
    possess faith kiyoshi a_4
    "Suddenly, the ghost moved toward Kiyoshi and passed through him. She had vanished completely inside of his body."

    john "Kiy... Kiyoshi?"

    show faith a_7 at faceleft with exchange
    faith "Would you believe me if I said yes?"

    "After everything that's happened today, I felt like I could believe anything. But if the stories I'd heard about ghosts were true..."

    think "Possession...?"
    john "Could you please get out of my friend?"

    show faith a_3 with exchange
    faith "She got what was coming to her, kid. I didn't even want to be bothered in the first place."

    "I reached for the device."

    john "I can't let you stay in there."

    faith "I see."

    show faith at Position(xpos=placement_of(john).xpos + 0.2, yalign=1.0)
    with MoveTransition(0.2)

    #usa2z: This could make sense as a timed challenge. Do we have coding for that? "Hit her" would be failure."
    menu:
        "She charged at me."

        "{s}I used the device to stop her.{/s}":
            placeholder

        "I hit her.":
            routename "Ghost Punchers"

    show john at Position(xpos=placement_of(faith).xpos - 0.115)
    with MoveTransition(0.1)
    show faith a_4
    play sound sfx_whack
    with hpunch

    show faith at anim_fall_over_right
    stop music
    "My arm moved without me having to tell it. I think it was Tori's muscle memory. Either way, the girl charging me fell to the ground."

    show john a_1 with exchange
    john "Did I just punch out a ghost?"

    "I tapped her with my foot. She was out cold."

    john "I guess even ghosts can be knocked out, as long as they're in a host."

    play music bgm_dark_fog
    "I knew she wouldn't be out forever. I had to get her out of that body quickly."

    show john a_0 with exchange
    think "I don't suppose the school nurse could help? Probably no exorcist around here either..."

    "But that line of thought gave me an idea."

    think "While she's no exorcist, Setsuna might know something about ghosts."

    menu:
        "If anyone I knew could cast out an evil spirit, it was Setsuna, the priestess in training. But would it really be a good idea to get such a frail girl involved in this?"

        "I sought Setsuna's help.":
            routename "The Exorcist"
            jump legacy_alien_murder_day3_setsuna

        "{s}I tried to use the device to expel the ghost.{/s}":
            routename "Necromancy for Dummies"
            # kmalloc: What exactly do you have in mind for this route, usa? There's no way you can just loop back to the normal Kiyoshi route after a ghost shows up.
            # uss2z: I feel like this option is nessesary. Isn't it more natural for John to turn to a paranormal solution he knows works, like the device, rather than one he doesn't know works, like exorcism? It can be left open for now to be the start for other Kiyoshi paths.
            placeholder

screen ghost_hunt_briefing():
    window:
        pos (int(1280 / 2), int(88 / 2))
        anchor (0.5, 0.5)
        xsize 1280
        xmargin 24
        ymargin 16
        yminimum 0
        ymaximum 88
        at briefing_show_hide
        add LiveMarquee(Text(
                u"Operation Locker Room Ghost Hunt \u2014 Mission Briefing \u2014 ",
                slow=False,
                style='briefing')) crop 0, 0, 1220, 58 xoffset -10

transform briefing_show_hide:
    subpixel True
    on show:
        zoom 0.0
        linear 0.5 zoom 1.0
    on hide:
        linear 0.5 zoom 0.0

style briefing is text:
    font "gui/fonts/Jura-DemiBold.ttf"
    color "#7de8f2"
    size 28
    layout "nobreak"

label legacy_alien_murder_day3_setsuna:
    scene black
    with dissolve
    "I luckily didn't encounter anyone else as I left the school, most likely since classes were still in session."
    "I did, however, get more than a few awkward stares as I dragged Kiyoshi's limp body through the streets."
    scene bg market day
    show carla a_0 at center, faceleft
    with dissolve
    show john a_0:
        offscreenleft
        ease 0.8 centerleft
    show kiyoshi a_4:
        offscreenleft
        0.3
        ease 0.5 left
    pause 1.0
    show carla a_7 at center with exchange
    show john a_0:
        ease 0.8 center
    show kiyoshi a_4:
        0.3
        ease 0.5 centerleft
    pause 1.0
    show carla a_7 at center, faceright with exchange
    show john a_0:
        ease 0.8 centerright
    show kiyoshi a_4:
        0.3
        ease 0.5 center
    pause 1.0
    show john a_0:
        ease 0.8 right
    show kiyoshi a_4:
        0.3
        ease 0.5 centerright
    hide john a_0 with moveoutright
    hide kiyoshi a_4 with moveoutright
    show carla a_4 at center, faceright with exchange
    $ carla.name = "Bystander"
    carla "I-I should call the cops, right?"

    scene black
    with dissolve
    "Fortunately, Tori's body had quite a lot of stamina, and Yui's body was pretty light, despite her chest size."
    "Even so, dragging a limp person through town was exhausting. If not for Tori's frankly amazing strength, there was no way I'd have been able to do it."

    scene bg shrine exterior day
    show john a_0 at centerleft
    show kiyoshi a_4 at left
    with dissolve

    "I made it to the shrine without being stopped. By then I was completely out of breath."

    john "Huff... huff... I should have just used the device..."

    "I still didn't know for sure if Setsuna could do this after all, let alone if she'd believe me."

    show john a_1 with exchange
    john "Well, we're here now..."

    "Stopping to take a breath, I glanced around the outside of the shrine."
    show john a_0 with exchange
    "I had never really believed in the supernatural, despite being friends with Setsuna. To me, it was just something that she did as a cultural practice."

    "Now, however, I had undeniable proof that not only were aliens real, but ghosts and spirits were as well."

    "That made me wonder whether any of the old tales Setsuna's father told me about the shrine were also true. Did the property really host the spirit of some bound forest god?"

    john "..."

    think "I'll investigate this later. Right now, Kiyoshi needs help."

    scene black
    with dissolve

    "As I entered the shrine, the wind outside seemed to take on a musical quality, like it was laughing."
    # TODO: Add wind sfx

    play music bgm_healing
    scene bg shrine interior day
    show setsuna b_3 at right
    with fade
    # TODO: animation and door sfx

    show john a_0:
        offscreenleft
        ease 0.8 centerleft
    show kiyoshi a_4:
        offscreenleft
        0.3
        ease 0.5 left

    "Setsuna was inside the shrine, dusting some of the decorations on the shelves. She didn't seem to notice us walking in."

    show john a_0 with exchange
    john "Um, hello?"

    show setsuna b_7 at faceleft with exchange
    setsuna "Oh, hello--"

    "Her eyes met Kiyoshi's limp body."

    show setsuna b_8 at center with ease
    setsuna "Is that girl okay!? What happened to her?"

    john "Well... it's a long story. She was possessed by a ghost and then attacked me. I knocked her out, and here we are."
    john "I, uh, heard about this place from a friend. I thought you might be able to do something."

    show setsuna b_7 with exchange
    setsuna "A ghost? I didn't even believe they were real..."
    show setsuna b_5:
        faceright
        ease 0.5 centerright
    setsuna "...Nevertheless, if what you say is true, I think I might have the tools to do something about it. Let me see..."

    "A part of me was kind of shocked. Did Setsuna really have training for this kind of thing?"

    setsuna "Lay her down. I'll make preparations."

    show setsuna b_0 at right, faceright with ease
    setsuna "Hey, Dad, do you still have any of that salt stuff left?"

    scene bg shrine interior day
    show john a_0 at centerleft
    show setsuna a_0 at centerright, faceleft
    with Fade(0.5, 1.0, 0.5)
    "After a few minutes, there was a strange series of circles set in salt between Setsuna and Kiyoshi."

    "Despite her demeanor, I could see the cracks in Setsuna's mask of confidence, the doubt in her eyes."
    "During my frequent visits, she told me how she doubted herself. I could see the same look in her face now."
    "Her incredibly careful movements, careful choices of words... She was putting on a show, not just for me, but for herself."

    think "Come on, Setsuna, I know you can do it..."

    show setsuna a_5 with exchange
    setsuna "I... hope this works..."

    show setsuna a_3 with exchange
    setsuna "{b}Begone, spirit!{/b}"

    show setsuna a_7 with exchange
    show faithGhost a_0 at center:
        yanchor 0.0
        easein 2.0 yanchor 1.0

    "The ghost was slowly pulled from Kiyoshi's limp body into the outlying circle."

    faith "Wha... Where am I?"

    show john a_1 with exchange
    think "Yes! I knew I could count on you!"

    setsuna "It... it worked!"

    show setsuna b_8 with exchange
    setsuna "You're... um..."

    faith "You don't know what you're dealing with, girl!"

    show setsuna a_7 with exchange
    show faithGhost at center
    show faithGhost at Position(xpos=placement_of(setsuna).xpos - 0.115)
    with MoveTransition(0.1)
    with hpunch

    "The ghost flew towards Setsuna and reached out, but crashed into the barrier she had erected."

    #Animate her "bumping into a wall"

    setsuna "Ah...!"
    show setsuna b_2 with exchange
    setsuna "Right, you can't escape that circle, can you? I really did it!"

    "The entire mood of the room seemed to lighten as the ghost relaxed back into the center of the circle."

    show faithGhost a_0 at center with ease
    faith "..."
    faith "I apologize. I feel so... full of anger... all the time."

    show setsuna a_0 with exchange
    setsuna "Well, let's start over. My name is Setsuna, and I'm a priestess here."
    setsuna "...Well, almost a priestess. What's your name?"

    "The ghost furrowed her brow and held her head."

    $ faith.name = "Faith"
    faith "I... Faith. My name is Faith, I think..."

    show setsuna a_2 with exchange
    setsuna "Faith, huh? That's a pretty name."
    show setsuna b_5 with exchange
    setsuna "Though you seem a little confused. Are you having trouble, um, remembering things?"

    "Faith nodded her head."

    show setsuna a_0 with exchange
    setsuna "That shouldn't be a problem, I think..."

    show setsuna b_5 with exchange
    "She began to mutter to herself."
    setsuna "{size=-5}In this kind of situation, you have to... right, and then...{/size}"

    show setsuna b_0 with exchange
    setsuna "I intend to help you pass on. I just need some cooperation."

    setsuna "Now, Faith, how did you die?"

    stop music fadeout 1.0
    faith "I was murdered."

    play music bgm_awkward_meeting
    show setsuna a_7 with exchange
    show john a_2 with exchange
    think "Murdered...?"

    show setsuna a_4 with exchange
    show john a_0 with exchange
    setsuna "A-Ah, well..."

    show setsuna a_0 with exchange
    setsuna "Do you... remember... who did it?"

    "The ghost hesitated."

    faith "I... I don't."

    show john a_2 with exchange
    john "What? How do you not know?"

    faith "I never saw anyone. I woke up choking from the smoke, and the room was ablaze..."
    faith "I don't remember anything else, but I have this deep-seated feeling... I {i}know{/i} it was arson."

    show john a_0 with exchange
    john "A fire, then...? That's right, I remember a story about that when I was in middle school..."

    stop music fadeout 2.0
    kiyoshi "And it wasn't arson."

    play music bgm_investigations

    show john a_2 at left with move
    show setsuna a_7 with exchange
    show kiyoshi a_1 at centerleft behind faithGhost:
        yanchor 0.0
        easein 1.0 yanchor 1.0
    kiyoshi "The PE teacher in question was revealed to have died in an accident. She seemed to have drank herself into a stupor, and her cig--"
    show kiyoshi at centerleft with exchange

    show faithGhost at faceleft with exchange
    john "How long have you been awake!?"

    show kiyoshi a_1 at faceleft with exchange
    kiyoshi "A while now, but I'm not--"

    show john a_0 with exchange
    faith "I didn't die in an accident! {b}I was murdered!{/b}"
    faith "{b}{i}And I will not leave this plane until I am avenged!{/i}{/b}"

    show kiyoshi a_0 at faceright with exchange
    kiyoshi "Really? That's very, very interesting..."

    show kiyoshi at faceleft with exchange
    show setsuna a_7 with exchange
    kiyoshi "Well, John, obviously, we have to invest--"

    show john a_2 with exchange
    john "D-Did you forget my {b}name{/b}, {i}Yui?{/i}"

    kiyoshi "Oh, oh! J-man... I mean, Tori, I'm just, uh... used to talking to..."

    stop music fadeout 2.0
    play music bgm_awkward_meeting
    kiyoshi "...Anyway! We obviously have to get to the bottom of this."

    show setsuna a_0 with exchange
    show john a_0 with exchange
    john "Obviously?"

    show setsuna a_5 with exchange
    setsuna "I need to help her pass on. I'll be grateful for any assistance..."

    show kiyoshi at faceright with exchange
    kiyoshi "Yes, my lady. I will humbly accept thy quest!"

    think "Oh my god, I can't believe I heard those words come out of Yui's lips."

    show setsuna b_3 with exchange
    setsuna "Right..."

    faith "Does this mean I can leave?"

    show setsuna b_4 with exchange
    setsuna "I'm afraid I can't let you leave the shrine after you possessed somebody... Dad would never let me hear the end of it."

    faith "Then, am I trapped in this circle until justice is served?"

    setsuna "Well, I can't keep the ward up that long..."
    setsuna "How can I keep you here without going that far...?"

    stop music fadeout 2.0
    "She pondered for a moment before a look of realization spread across her face."

    play music bgm_healing
    show setsuna a_0 with exchange
    setsuna "I see. A prison that binds a person to this shrine... Do you know what that is?"
    show setsuna a_5 with exchange
    setsuna "I know that prison. I've lived in it all my life."
    show setsuna a_4 with exchange
    setsuna "That prison is my own body."
    setsuna "The body of a priestess--{w=0.4}er, priestess-in-training, that is--{w=0.4}should be enough to confine your spirit."
    show setsuna b_9 with exchange
    setsuna "And my own straitjacket of a body will do the rest."

    show faithGhost at faceright with exchange
    faith "I will not do any such thing."

    show setsuna a_4 with exchange
    setsuna "I'm afraid you don't have a choice."


    "I stood, mouth agape, as Setsuna wiped her foot across the salt."

    show john a_2 with exchange
    john "Setsuna... No!"
    possess faith setsuna a_7

    think "Just how miserable is she in that body?"

    show faith a_7 with exchange
    faith "I'm..."

    "I knew that I had to help this {q}Faith{/q} pass on... if only for her."

    show faith b_8 with exchange
    faith "I can't... leave this body...!"

    show faith a_8 with exchange
    faith "{b}{i}Let me go!{/i}{/b}"

    nemuri "What's with all the ruckus in there?"

    show john a_0 with exchange
    show nemuri a_0 at offscreenright behind faith
    show nemuri a_0 at right, faceleft with MoveTransition(1.0)

    nemuri "{i}Yawn.{/i} Hey, Setsuna, who're your friends?"

    show faith a_4 at faceright with exchange
    "Faith looked down in shame."

    faith "I... You are Setsuna's father, correct? I am not your daughter. I am a ghost she exorcised."
    faith "She's... trapped me in her body until I can pass."

    show nemuri a_3 with exchange
    "The man looked at me."

    nemuri "Is this true?"

    john "Yes."

    show nemuri a_4 with exchange
    nemuri "...What a wonderfully brave daughter I've been blessed with."

    think "T-That's all he has to say!?"

    show nemuri a_0 with exchange
    nemuri "Would you like some tea, Miss...?"

    show faith a_4 with exchange
    faith "I... Just call me Faith."
    show faith a_9 with exchange
    faith "I would love to feel warmth in my throat, a bitter taste on my tongue... I've missed these sensations so much."

    nemuri "Would you like some too, girls?"

    show faith b_7 at faceleft with exchange
    john "Um, we're fine. We really need to get started on solving this case."

    nemuri "Suit yourself."

    john "Let's get going, {q}Yui.{/q}"

    stop music fadeout 2.0
    scene black
    with dissolve

    "We left the shrine with heavy thoughts weighing on my mind."
    "I couldn't say I was too fond of Faith... but I needed to get her {i}out{/i} of my friend."
    "That was enough for me."

    scene bg shrine exterior day
    show john a_0 at faceright:
        pos (0.4, 1.0)
        anchor (0.5, 1.0)
    show kiyoshi a_0 at centerright, faceleft
    with dissolve
    play music bgm_fast_talkin

    "On the way out, Kiyoshi suddenly spoke."

    kiyoshi "You know, I think I recognize that ghost."

    john "Wait, really?"

    show kiyoshi a_1 with exchange
    kiyoshi "Well, her breasts."

    john "..."

    show kiyoshi a_0 with exchange
    kiyoshi "Really! Didn't you recognize her measurements?"

    john "Humor me."

    kiyoshi "They're exactly identical to the nurse's. They looked about the same height, too. Therefore..."

    "Kiyoshi cracked a confident smile."

    kiyoshi "They must be twins."

    show john a_2 with exchange
    john "You're concluding that all from her measurements? Seriously!?"

    show john a_0 with exchange
    kiyoshi "It's better than nothing, isn't it? I'll visit the nurse's office in the morning."
    show kiyoshi a_1 with exchange
    kiyoshi "My clever charm will surely strike her heart and win her to our side in this investigation."

    show john a_2 with exchange
    john "{i}No,{/i} if anything I'll be talking to her."

    show john a_0 with exchange
    show kiyoshi a_3 with exchange
    kiyoshi "You're no fun."

    think "Haven't we had enough {q}fun{/q} for one day?"

    stop music fadeout 2.0
    kiyoshi "Well, see you tomorrow."
    show kiyoshi a_0:
        faceleft
        easeout 0.5 left
    show john at faceleft with exchange
    john "Hey, wait just a minute! I need to change you back first!"

    show kiyoshi a_5 at left, faceright with exchange
    "Kiyoshi looked extremely disappointed."
    kiyoshi "Oh, right... I must have forgotten..."

    show kiyoshi a_0 with exchange
    john "Right, right. Hope no one else is around. I don't see anyone looking outside in the shrine at least."

    "I raised the device at Kiyoshi first."

    play sound sfx_device
    show expression alien_particles(1500, 340, 700) as particles:
        xpos placement_of(kiyoshi).xpos
        ypos 0.6
        alien_particles_fadein
    morph begin alien kiyoshi kiyoshi gym_female a_0
    morph finish kiyoshi
    hide particles with dissolve
    kiyoshi "The Kiymaster is back in business!"

    think "And back in that ridiculous outfit."

    show kiyoshi a_0 with exchange
    "I pointed it at myself next."

    play sound sfx_device
    show expression alien_particles(1500, 340, 700) as particles:
        xpos placement_of(john).xpos
        ypos 0.6
        alien_particles_fadein
    morph begin alien john john uniform a_0
    "I felt my body rapidly changing once more."
    morph do john
    "The weight from my chest shrank further and further until it was gone, my clothes transformed and I felt my hair rapidly receding."
    morph end john
    hide particles with dissolve

    think "I guess I'm back to the old me..."

    play music bgm_comfortable_mystery
    john "Well, this was... quite a day. See you tomorrow, Kiyoshi."

    kiyoshi "Be ready for tomorrow, an even bigger day awaits, J-man!"

    scene black
    with wiperadial_vert

    jump legacy_alien_murder_day4
