##Day 5: Jane's first day of school
# John, now "Jane", stays home and gives the device to Kiyoshi for his own
# protection, since she cannot visit school while stuck in her body.
# An hour into the school day, Kiyoshi contacts Jane telling her that the
# problem is now solved and she can come to school.
label legacy_alien_murder_day5:
    resetstate
    body john johnGB_legacy
    accessory kiyoshi clear

    title "Day 5" "First Day of School"
    unlock legacy_alien_murder_day5 (
        ("not fGirlAcceptance", "No cuddles", {"fGirlAcceptance": False}),
        ("fGirlAcceptance", "Cuddles", {"fGirlAcceptance": True})
    )

    scene bg house_honda bedroom_kiyoshi day
    with dissolve

    play music bgm_airport_lounge

    "Light flooded my senses, waking me up from my sleep."

    if fGirlAcceptance:
        "I felt like I had only managed to fall asleep an hour or so ago."
        show john a_10 at left:
            yanchor 0.0
            easein 1.0 yanchor 1.0
        john "..."

        show john:
            yanchor 1.0
        think "Last night... I {i}was{/i} in control, wasn't I?"

        show john a_15 with exchange
        "I squinted at the rays of the sun peeking through the windows and rubbed my eyes."
        "The strange feelings I had felt that night seemed to have disappeared along with the night sky. Perhaps they were part of some strange dream?"

        show john a_11 with exchange
        think "Yeah, I mean, it was just a joke. I always mess with Kiyoshi. Last night wasn't any different."
        show john b_18 with exchange
        think "Once this is all over I bet we'll have a good laugh about all of this. Or at least, I will. {size=-5}I hope.{/size}"

        "I took another look at his sleeping body."

        show john b_7 with exchange
        think "Well... as long as I'm {q}Jane{/q}, I guess there's no harm in playing along. {w=0.5}For now."
    else:
        think "It's morning already?"
        show john b_3 at left:
            yanchor 0.0
            easein 1.0 yanchor 1.0
        "I slowly sat up, yawning and stretching my arms out."
        "Luckily I did manage to catch a little sleep last night. As much as a guy recently transformed into a girl could, at any rate."

    show john b_8 with exchange
    "I took a quick look around Kiyoshi's room. I had been here plenty of times before, but as a girl the whole place just seemed to be a bit... foreign."
    "Kiyoshi was still fast asleep, dozing in what seemed to be a state of pure bliss."

    kiyoshi "Ah, Jane..."

    show john b_4 with exchange
    john "Wait... what?"

    kiyoshi "Oh, Jane, you're so hot. Almost as hot as Sayaka."

    show john a_16 with exchange
    "My cheeks flushed red."
    show john a_15 with exchange
    john "Uh, thanks for the, um, compliment... But I think you should wake up now."

    show john:
        easein 1.0 yanchor 0.8
    "I gently shook him a few times, but my efforts seemed futile as he just continued to mumble."

    show john:
        yanchor 0.8
    kiyoshi "The way you're straddling me, it's kind of kinky..."

    show john b_24
    play sound sfx_whack
    with hpunch
    john "{b}Wake up!{/b}"

    show john:
        easein 0.3 yanchor 1.0
    show kiyoshi a_5 at center, faceleft:
        yanchor 0.0
        easein 0.3 yanchor 1.0

    "Kiyoshi bolted upwards and hopped out of the chair."

    show john:
        yanchor 1.0
    show kiyoshi:
        faceright
        yanchor 1.0
    kiyoshi "What, what's going on!? Is there a fire? A burglar? Aliens!?"

    show john b_7 with exchange
    john "No, just... Never mind."

    show kiyoshi a_0 at faceleft with exchange
    kiyoshi "If you say so. Well, if there isn't any trouble, then we should get ready for school now."

    show john a_9 with exchange
    john "School?"

    "I motioned towards my body."

    show john a_10 with exchange
    john "You know I can't go looking like this. No one will recognize me."

    kiyoshi "I'll just tell them you're with me then."

    show kiyoshi a_6 behind john
    kiyoshi "Who knows, maybe Sayaka will even get jealous."

    show john a_6 with exchange
    john "You don't understand, though. I--err, Jane--my current body doesn't even go to our school. I practically don't exist."

    show kiyoshi a_0 with exchange
    show john b_8 with exchange
    john "Do you think they'll just let me waltz right in because I know you?"

    kiyoshi "Hmm, guess not. Maybe the device is working again."

    "Kiyoshi reached over to his bedside table and picked up the device."

    show kiyoshi a_1 with exchange
    kiyoshi "Look, it only needs a bit more time to charge and then we can use it again. For now, you can just hold onto the device and show up late to class or something."

    show john b_2 with exchange
    "I briefly considered what the day might hold."
    "Jack wasn't stupid. He knew that there are two students {q}investigating{/q} him, and that they weren't aware that he had a magic alien device."
    "He had also likely figured out that these two students' bodies were mere disguises."
    "If I didn't show up to school, would he make the connection that I was one of those girls?"
    show john b_4 with exchange
    "If that were the case, Kiyoshi would be immediately implicated..."

    john "No, you take it with you. Without the device, you'll be completely helpless, and I'm kind of worried about what Jack might do to you."

    show kiyoshi a_2 blush with exchange
    kiyoshi "Ah, right. You know, your concern is really... {w=0.5}cute."

    if fGirlAcceptance:
        show john a_11 with exchange
        "I put my hands on my hips and fought a grin that pressed itself on my face."
    else:
        show john a_21 with exchange
        john "The only thing {q}cute{/q} here is how you don't know the extent to which I'm going to rearrange your stupid, dorky face after this is all over."

        show kiyoshi a_5 with exchange
        kiyoshi "R-Right..."

    show kiyoshi a_1:
        faceright
        ease 1.0 right
    pause 1.0
    show kiyoshi at right with exchange
    play sound sfx_door_open

    "Kiyoshi pocketed the device and opened the bedroom door."

    kiyoshi "Anyway, I'm starving. How about you?"

    show john a_3 with exchange
    john "Well, actually, yeah. I am a little hungry."

    show kiyoshi a_6 with exchange
    "Kiyoshi motioned for me to step outside."

    kiyoshi "Ladies first."

    if fGirlAcceptance:
        show john b_13 at center with ease
        "I couldn't help but break into a smile despite myself as he held the door open for me."
        show john:
            easeout 0.3 yanchor 0.9
            ease 0.6 yanchor 1.0
        "After a clumsy attempt at a curtsy, I left the room."
    else:
        show john b_7 at center with ease
        john "Thanks."
        "My response was as flat as I could muster."

    show john:
        easein 2.0 offscreenright

    scene bg house_honda livingroom day
    with fade
    accessory kiyoshi set glasses
    show kiyoshi a_0 at center, faceleft
    show john b_5 at right, faceleft
    with easeinright

    john "So what have you got to eat around here, Kiyoshi?"

    pause 1.0

    show kiyoshi a_1 at faceright with exchange

    kiyoshi "...Say my name again."

    show john b_4 with exchange
    john "Huh, sure, I guess. {q}Kiyoshi.{/q}"

    pause 0.5
    show kiyoshi a_2 with exchange
    pause 0.5

    show john b_19 with exchange
    john "...Kiyoshi?"

    show john b_24 with exchange
    john "{b}Kiyoshi!{/b} Are you even listening to me?"

    kiyoshi "Heheh, it sounds so nice having a girl say my name."

    john "Could you knock it off for just five minutes, Kiyoshi?"

    kiyoshi "So nice..."

    john "{i}Food{/i}, Kiyoshi. Where's the food?"

    show kiyoshi a_1 with exchange
    kiyoshi "I know for a fact we have cereal, but, otherwise, we're a little light until my uncle goes grocery-shopping."

    show kiyoshi a_0 at faceleft:
        ease 1.0 xpos 0.2
    show john b_15 with exchange
    "Kiyoshi opened up a cabinet which contained various sugary cereals."
    "Normally I'm not one to complain about food, but for some reason I didn't feel like eating any of that sugary processed junk."

    show john a_9 with exchange
    john "I don't suppose there's something else you have we can eat? Something that's at least a little more... healthy?"

    show kiyoshi at faceright:
        ease 0.6 xpos 0.3

    "Kiyoshi paused in thought for a minute, and then he walked over to another drawer and pulled out some pancake mix."

    kiyoshi "If you want, we can have pancakes instead."

    show john a_3 with exchange
    john "That doesn't sound too bad, actually."

    show kiyoshi a_5 blush with exchange
    kiyoshi "Well, the truth is, I don't know how to cook, so..."
    "He glanced at me."

    show john a_0 with exchange
    john "You're hopeless, you know that?"

    show kiyoshi a_2 with exchange
    "Kiyoshi laughed nervously and placed the pancake mix back in the drawer."

    show kiyoshi a_4 at faceleft with exchange
    kiyoshi "Cereal it is, then."

    show john b_11 with exchange
    john "Wait!"

    show kiyoshi a_0 with exchange
    kiyoshi "Huh?"

    menu:
        "I remembered making pancakes on at least one occasion. It was a long time ago, but..."

        "I decided to make the pancakes myself.":
            if fGirlAcceptance:
                john "I'll make the pancakes myself if that's the case."

                show kiyoshi a_2 at faceright with exchange
                kiyoshi "Alright, here you go then. Make some for me too, please."

                "Kiyoshi handed me the pancake mix."

                show john b_18 with exchange
                john "Sure, but only because it's your food."

                scene black
                with wipeblinds_horiz

                "As I was measuring out the ingredients, I accidentally spilled a bit too much pancake mix into the bowl."

                "I started adding in more ingredients to compensate for my mistake, to balance out the recipe. By the end of it, though, I had about fifty percent more than I wanted to make."

                john "Looks like we're going to have a lot of leftovers."

                "Kiyoshi gave me a funny look, almost as if I was challenging him. I shrugged it off thinking it was Kiyoshi just being Kiyoshi."

                scene bg house_honda livingroom day
                show john b_23 at centerright:
                    faceleft
                show kiyoshi a_1 at centerleft:
                    yanchor 0.85
                with wipeclock
                "After the pancakes were made, I served myself four from the stack of twelve and poured a light amount of syrup over the top of the stack."

                show john:
                    ease 0.5 yanchor 0.85
                "Kiyoshi served himself four as well and drizzled syrup all over it, drenching the pancakes in the process."

                show john b_18:
                    yanchor 0.85
                "By the time I'd finished off my second pancake, I was already starting to get full. I probably had room for just one more pancake."

                show john b_17 with exchange
                "Looking over towards Kiyoshi, he was already on his fourth pancake, scarfing it down as if he hadn't eaten in a week."

                john "Wow, you're really hungry, aren't you?"

                "Kiyoshi nodded and grabbed his glass of milk and glugged it down to help him swallow the pancake slurry in his mouth. He dropped his empty glass onto the table and burped."

                show kiyoshi a_0 with exchange
                kiyoshi "Hm, I think I still have room for a few more pancakes after this one."

                "I continued to eat my mine, but, after finishing my third, I was stuffed."
                "Kiyoshi, on the other hand, had just finished his fifth pancake and showed no signs of slowing down."

                show john b_14 with exchange
                john "If you're still hungry you can have my last pancake, Kiyoshi."

                show kiyoshi a_2 with exchange
                kiyoshi "I think I can fit it in. Thanks, Jane."

                show john b_1 with exchange
                "I blushed."
                john "You're welcome."

                "Kiyoshi started eating again, though he seemed to be slowing down quite a bit."

                show john b_4 with exchange
                show kiyoshi a_5 with exchange
                "Upon finishing his sixth pancake, he grabbed yet another one. His eating had slowed to a glacial pace, and he was looking a little sick."

                john "Uh, Kiyoshi, are you feeling okay?"

                kiyoshi "I'm as strong as ever! Why do you ask?"

                john "You're not actually going to try and eat every single pancake, are you?"

                show kiyoshi a_2 with exchange
                "Kiyoshi laughed loudly at my question, but, by this point, I was concerned that either the pancakes or all the syrup he'd used had somehow fried his brains."

                kiyoshi "You've known me for such a long time, yet you still don't get it, Jane?"

                john "What are you talking about?"

                kiyoshi "A pretty girl made this food for me, and I refuse to let a pretty girl's cooking go to waste."

                show kiyoshi a_0 with exchange
                kiyoshi "I'll make sure I eat all of this food, no matter how much there is."

                "Kiyoshi seemed to regain his confidence, and he started shoveling more pancake into his mouth. Soon enough, he'd arrived at his ninth pancake."

                show john b_9 with exchange
                john "You {i}really{/i} don't have to do this, Kiyoshi. I don't want you to get sick and keel over."

                show kiyoshi a_5 with exchange
                "Kiyoshi was losing his steam from that second wind earlier and lurched over looking rather queasy. Only a few more mouthfuls of pancake remained."
                "Kiyoshi ignored my concern and gorged himself on yet another mouthful. He leaned down, looking like he was about to vomit."

                show john b_24 with exchange
                john "Just stop eating, Kiyoshi! You look like you're about to die or something."

                kiyoshi "No, there's only a few bites left. I'm almost there."

                show john b_9 with exchange
                john "This is crazy, Kiyoshi. Let me at least help you out. I'm kinda hungry again, and I wouldn't mind having the rest of that pancake."

                "As I reached over to grab the remnants of the last pancake with my fork, Kiyoshi grabbed his plate and held it out of my reach."

                show kiyoshi a_4 with exchange
                kiyoshi "I know what you're trying to do, Jane. You were struggling to finish up that third pancake. I don't want to force you to eat more than your stomach can handle."

                show john b_2 with exchange
                john "Why can't I just help you finish off that pancake? Or, you know, we could always store the rest of it for later."

                kiyoshi "You know very well that's impossible, Jane. This is something I must do alone."

                show kiyoshi a_5 with exchange
                "Kiyoshi leaned over his knees again, almost throwing up in the process."

                show john b_24 with exchange
                john "Seriously, just throw it away, store it, {i}anything{/i} else. I can't watch you do this to yourself."

                show kiyoshi a_3 with exchange
                kiyoshi "I'm going to finish it, and that's final."

                show john b_4 with exchange
                "Using what must have been every ounce of willpower he had, Kiyoshi lifted his plate to his mouth and scraped the remaining pancake in and swallowed. He then set the plate back down."

                show kiyoshi a_1 with exchange
                kiyoshi "It is done."

                "I stared at Kiyoshi in shock. He actually managed to finish it all."

                show john b_5 with exchange
                "Now that it was over, the whole thing seemed kinda comical. I couldn't help but giggle at how stupid Kiyoshi had acted."

                show john b_1 with exchange
                john "You're such a dummy, Kiyoshi."

                jump legacy_alien_murder_day4_afterfood

            else:
                show john a_8 with exchange
                john "Well, it's been a while since I've made pancakes, but I guess I can try."

                show kiyoshi a_6 at faceright with exchange
                kiyoshi "I'm sure whatever you make will be delicious."

                "Kiyoshi flashed a smile that gave me shivers."

                john "Don't look at me like that, it's... unsettling."

                kiyoshi "I'm sorry, but it's not everyday a man has his meal made for him by such a beautiful lady."

                show john b_8 with exchange
                "I stared back at him flatly hoping that it got the point across."

                show kiyoshi a_2 with exchange
                kiyoshi "Alright, alright, I get it."

                show kiyoshi:
                    ease 0.5 yanchor 0.85
                "Kiyoshi sat down and waited for me to finish, not even offering to help clean up."

                show kiyoshi:
                    yanchor 0.85
                "I was tempted to put too much salt in the pancakes and feign ignorance, but decided against it."

                show black
                with wipeclock
                show john at centerright with exchange
                pause 0.2
                hide black
                with wipeclock

                john "Alright, here you go."

                "Kiyoshi's face was painted with obvious conflict as I set the slightly blackened pancakes in front of him."
                "I usually didn't get so defensive, but for some reason I felt strangely embarrassed at the idea of someone not liking my cooking."

                john "Look, I told you, it's been a while."

                "Resolve finally crossed Kiyoshi's face and he took a pancake and tested a few bites of it."

                kiyoshi "No, they're great! I swear!"

                show john:
                    ease 0.5 yanchor 0.85
                "I sat down and began to eat as well."
                "...They most certainly were {i}not{/i} great."

                show john:
                    yanchor 0.85
                john "If you say so..."

                kiyoshi "Of course they ar--{nw}{w=0.2}"

                "Kiyoshi was interrupted by a violent cough that sent a chunk of black pancake from his throat."

                show john:
                    ease 0.5 yanchor 1.0
                "My cheeks flushed red as I stood up from the table."

                john "That's it, we're having cereal."

                scene black
                with dissolve

                "With a poorly faked look of disappointment, Kiyoshi took the plate of pancakes, disposed of them, and brought back some cereal."
                "After browsing the choices, I decided on a bowl of {q}Chocolate Rice Poppers,{/q} while Kiyoshi settled on {q}Marshmallow Mateys.{/q}"

        "I decided to have the cereal instead.":
            show john b_10 with exchange
            john "You know what, I'll just eat the cereal. What do you have?"

            "Kiyoshi pulled out several boxes of cereal. Each one had a familiar mascot on them."
            "After browsing the choices, I decided on a bowl of {q}Chocolate Rice Poppers,{/q} while Kiyoshi settled on {q}Marshmallow Mateys.{/q}"
            scene black
            with dissolve

    "It didn't take me long to finish eating. It tasted pretty much like you'd expect a {q}flavored rice cereal{/q} to taste."
    "Kiyoshi, on the other hand, was treating his breakfast like he did his lunches at school."
    "He started with eating the hard cereal granules, separating the marshmallows as he scooped the cereal bits. With his finger, he methodically leveled each spoonful, as if his spoon were a measuring cup, and then flipped it over inside his mouth."
    "Then, when finished with the hard pieces, he piled as many marshmallows as he could onto each spoonful and shoved them all at once into his mouth, one marshmallow mound after the next, until nothing was left in his bowl."
    scene bg house_honda livingroom day
    show john a_3:
        centerright
        faceleft
        yanchor 0.85
    show kiyoshi a_0:
        centerleft
        yanchor 0.85
    with dissolve

label legacy_alien_murder_day4_afterfood:
    show kiyoshi a_2:
        easein 0.5 yanchor 1.0
    kiyoshi "Well, I'd better head out for school now. I'll contact you if I figure anything out, but you can just chill here till then."

    show john a_5:
        faceleft
        easein 0.5 yanchor 1.0
    john "Alright, Kiyoshi. Have a good day at school. And good luck."

    kiyoshi "Right!"

    show kiyoshi at faceleft:
        easeout 1.0 offscreenleft
    play sound sfx_sliding_door_close

    stop music fadeout 2.0
    "Kiyoshi flashed a thumbs up and headed towards school, leaving me alone in his house."

    show john a_7 with exchange
    pause 1.0
    think "Well, I've got some time to kill... Might as well take a shower."

    scene black
    with dissolve
    pause 1.0

    "I entered Kiyoshi's bathroom and gazed at myself in the mirror."

    play music bgm_groove_grove
    john "My god, this is all like some strange dream I can't wake up from."

    "Tentatively, I reached up towards my face, feeling how soft and smooth it now was."

    "I traced my finger down my body, outlining the feminine shape filling out my uniform, its contours foreign yet familiar."

    "My finger continued its way down the center of my chest, into the cleft between my breasts. Mechanically, I unbuttoned my shirt and set it aside."

    "My hands struggled around the waistband of the skirt, trying to find some way to loosen it."

    "Upon finding the zipper, I took off the skirt and looked down, seeing my shapely legs hugged closely by the hosiery. I pulled down the pantyhose carefully, leaving myself in only my underwear."

    john "Hello, Jane. I guess, {q}hello me,{/q} since this is what I would have looked like had I been born a girl..."

    "I shook myself from my introspection and reached behind, fumbling with the bra's clasp. As the straps fell limp across my shoulders, the tension binding my chest released, and I tugged off the bra. My cheeks flushed with heat as I saw my breasts."

    "Embarrassed, I looked away and finished undressing. Opening my eyes to find a naked woman in the mirror was incredibly disorienting."

    "Before hopping in the shower, I posed a little in front of the mirror, curious how my body looked when I moved and how my facial expressions had changed."

    john "Alright, I've played around enough. I need to get moving."

    "I started the shower and found a comfortable temperature, less hot than I preferred when I was a guy but still warm."

    scene cg johnGB shower face_0
    with dissolve
    "I gasped when the water hit my silky skin, as if it were the first time anything warm had graced it. I closed my eyes and reveled in the sensations as it washed over me."

    menu:
        "This body belonged entirely to {i}me{/i}. There was nothing stopping me from exploring every inch of it, touching it like the water was..."

        "I gave in and explored my new form.":
            show cg face_1
            "As the water hit my skin, my muscles tensed. I winced and flinched slightly from the new experience of hot water flowing over this body."

            "My hands, now with minds of their own, explored my new body. They caressed the feminine curves now mine, the wide hips, smaller waist. I lifted a leg up and touched where I once had hair, now sleek."

            "Smoothing my stomach, I noticed it was now flat and slender, with tight muscles taut underneath."

            show cg face_3
            "My breathing was getting heavier, my inhibitions flowing away like the water from the showerhead. Testing a nipple in one pair of fingers, I tweaked it too hard, eliciting a gasp of pain."

            show cg face_2
            john "Ow! I can see why girls want tenderness."

            "Massaging my breasts, I slowly worked a hand downwards to find the epicenter of my transformation, the thing that confirmed I was indeed a woman."

            think "I'm hairless here as well..."

            "Hesitantly rubbing the area, I soon learned I was only just becoming aware of the many differences between men and women."

            show cg face_3
            "In my exploration, I felt a sense of opening and wanting something inside of that opening. I spread open, pushing deeper. With my teeth gritted, I started going faster and faster, my body getting hotter with each thrust."
            "I arched my back as a sudden bliss exhilarated every nerve in my body."

            scene black
            with dissolve

            "I wasn't sure how much time had passed during my poking and prodding, but my legs felt so rubbery I didn't care."

        "I washed up without doing anything.":
            show cg face_1
            think "No, this is too weird. I need to hurry up and get out of here."

            "I picked up the soap and began washing myself."

            show cg face_2
            "Multiple times, I was tempted to stray and explore this new form, but I kept on track, my unease with touching myself as a girl defeating my curiosity about this body."

            scene black
            with dissolve

    stop music fadeout 2.0
    "After exiting the shower, I quickly dried off and dressed in my uniform again."

    pause 1.0
    scene bg house_honda livingroom day
    show john a_9 at center, faceleft:
        yanchor 0.85
    with dissolve

    play music bgm_comfortable_mystery_4

    "After my experience in the shower, I returned to Kiyoshi's living room, sat down on the couch, and began to take in this whole situation."
    "I was now a girl, and, despite being called Jane, I didn't really mind all that much. Perhaps it had something to do with those mental changes?"

    think "Honestly, I don't know what Kiyoshi was thinking, zapping me with that device to give me a new personality."

    stop music fadeout 2.0
    play sound sfx_text
    pause 1.0

    "I heard my phone's familiar text message chime and hurriedly checked the sender."

    show john at faceleft:
        easein 0.3 yanchor 1.0
    "It was from Kiyoshi!"

    text start john
    text title "Kiyoshi"

    msg kiyoshi "Hey you can come to school now, problem solved. This thing is SO COOL"

    "That... did not fill me with any amount of hope."

    "I quickly tapped out a message in return."

    msg john "wait, what?? what the heck did you do kiyoshi???"

    "I stared at my own message for a moment after tapping the send button."

    "That was what I wrote? Seriously? I couldn't even write normally?"

    text end

    think "What did Kiyoshi do to my head...?"

    john "..."

    "There was no way I was just going to sit around and wait for him to reply. I grabbed my things and left for school immediately."

    scene bg school entrance day
    show john a_8 at center
    with Fade(0.5, 1.0, 0.5)

    play music bgm_fast_talkin

    "I arrived at school, hoping Kiyoshi had {q}solved{/q} the problem, but I had no idea just how well he {i}had{/i} {q}solved{/q} it..."

    "I didn't see Kiyoshi anywhere near the entrance."
    think "Maybe he's by the lockers?"

    scene bg school lockers day
    show john a_8 at centerright, faceleft
    with dissolve

    think "Nope. Nothing."

    "I was starting to get worried that someone would see me wandering around."

    text start john
    text title "Kiyoshi"

    msg john "where are you??"

    think "It's not like he ever answers his text messages, but--{w=1.0}{nw}"

    play sound sfx_text

    "Almost immediately, my phone went off."

    msg kiyoshi "In class, what did you think?"

    think "How did he expect to fix anything in the middle of class!?"

    msg john "!?!?!?"

    "...It was all I could muster."

    play sound sfx_text
    msg kiyoshi "Just trust me. Come to connies class."

    "I most certainly did not trust Kiyoshi, but..."

    text end

    scene bg school hallway_1 day
    show john b_8 at Position(pos=(0.7, 1.0), anchor=(0.5, 1.0))
    with Fade(0.5, 1.0, 0.5)

    "I hiked it up the stairs, checking my phone for the time. Yep, it was still first period."

    play sound sfx_knock
    "I tentatively knocked on the door."

    # TODO: footsteps
    "Soon I heard the familiar sounds of a certain someone's footsteps lightly tapping towards the door."

    play sound sfx_sliding_door_close
    show bg school hallway_1 day_open with dissolve

    pause 0.2
    show john:
        easein 0.5 xpos 0.4
    show yui a_3 at centerright, faceleft behind john with dissolve
    show bg school hallway_1 day with dissolve


    show john:
        xpos 0.4
    show yui a_2 with exchange

    yui "Jane! You're late yet {i}again!{/i}"

    stop music fadeout 2.0
    show john b_4 with exchange
    john "Yeah, sor--wait, Jane?"

    play music bgm_dark_fog
    show yui a_3 with exchange
    yui "Don't try to get out of this by pretending that isn't your name! I only fell for that trick once, and I'd never fall for it with you!"

    think "Kiyoshi!"

    "Whatever happened to Yui, Kiyoshi's fingerprints were all over it."

    yui "--and punctuality is the key--hey, are you listening, Jane!?"

    think "There's that name again..."

    show john a_11 with exchange
    john "Yes, of course. Your lectures are very important to me."

    show yui b_1 with exchange
    yui "Yet you never take them to heart, otherwise your grades would be ten times better. Back to punctuality, it is the start--"

    show john a_9 with exchange
    "As she droned on, her voice in the background like the low hum of an engine, I couldn't help but wonder who else he'd changed like Yui."

    "Once she finally ended her lecture, I entered the classroom."

    scene bg school classroom_1
    with fade

    "Upon entering the room, Ms. Williams looked away from her board and at me."

    show connie a_0 at center with dissolve
    connie "Oh, finally here, Jane? Well, lucky for you, we're to the best part of the lecture: the virtues of Heron's formula! You'd be a {i}square{/i} not to use it!"

    # micromegas: could probably cricket her to death here, but, assuming not, proceeding...

    hide connie
    with dissolve

    "Trying to purge from my mind Ms. Connie's use of {q}Jane,{/q} I sat down and stared at Kiyoshi smiling nearby. I narrowed my eyes at him and he blew me a kiss. I shuddered."

    think "Does he just interpret any glance from a girl as interest? But with what happened last night..."

    "I felt butterflies in my stomach despite myself. I knew I should be disgusted, yet..."

    "...Yet I did enjoy it, and I was starting to hate myself a little for it."

    "I knew it was just from Kiyoshi using the device on me, from how he changed me into his {q}ideal{/q} girl, but I couldn't deny those feelings. They felt too good to deny."

    think "I hope I can undo most of this..."

    "I repeated that phrase to myself, but the words became more and more hollow with each passing minute. I was certain that, if I couldn't find some way back soon, I might not even {i}want{/i} to return to my normal self."

    stop music fadeout 2.0
    scene bg school classroom_1
    with Fade(0.5, 1.0, 0.5)

    play sound sfx_bell noloop

    "When class was finally over, I ran over to Kiyoshi, who was messing around with the device at his desk."

    show john a_6 at centerleft
    show kiyoshi a_2 at centerright, faceleft
    with dissolve

    kiyoshi "Yo. Pretty smart, eh? Now you should have {i}no{/i} problems attending school as a girl because everyone thinks you've always been one! All hail Kiyoshi, right?"

    show john b_24 with exchange
    john "Kiyoshi...!"

    play music bgm_investigations
    kiyoshi "What? You said you wanted to attend school."

    show john a_7 with exchange
    "I swiped the device out of his hands. No power."
    "I glared at him with as much intimidation as I could muster."

    show kiyoshi a_3 with exchange
    kiyoshi "Hey, now! Don't be angry at me... I thought it was the right thing... Besides, it's only temporary."

    show john a_6 with exchange
    "I shook my head in frustration, but feeling my breasts move around and the skirt dance around my legs only further emphasized, further ingrained into me, that I was a girl."

    show john b_9 with exchange
    john "You f-fruity doofus! Now Jack is going to know for sure that we're the ones after him!"

    stop music fadeout 2.0
    show kiyoshi a_5 with exchange
    "Once again, the right words just wouldn't come out. Kiyoshi smirked at my {q}curses{/q} at first, but his expression became more serious when he saw the dour look on my face."

    kiyoshi "I promise, I'll change everything back once this is over! Absolutely promise!"

    play music bgm_evening_fall_piano
    show john b_11 with exchange
    "At his promise, my heart skipped a beat. I felt so warm and mushy inside that I was afraid I'd lose myself for a second."

    john "Do you really mean it?"

    kiyoshi "Of course! I'd never lie to a pretty girl."

    show john b_14 with exchange
    "My head was filled with confusing feelings, feelings I was certain only an overly emotional, effeminate girl would have in such abundance. Unable to contain myself, tears formed in my eyes. I wiped them away quickly and breathed in deeply."

    kiyoshi "Y-You okay?"

    john "Yes, but please, Kiyoshi, make good on that promise..."

    scene black
    with dissolve

    "Kiyoshi and I left class, his arm around my back. And I didn't mind it so much. It liked knowing he was there for me."

    "I went through the rest of my classes relatively normally, other than the fact everyone was calling me {q}Jane{/q} rather than {q}John{/q}--and the fact I was in a girl's body. At lunch, I met up once again with Kiyoshi and the gang."

    scene bg school cafeteria
    show john a_9 at centerleft
    show katrina a_0 at left
    show kiyoshi a_1 at centerright, faceleft
    show kyoko a_8 at right, faceleft
    with dissolve

    "Lunch conversations went mostly as they did on any average day, although the week had been anything but average."
    "I was silently gazing outside for most of lunch, wondering how we would catch the murderer, how I would return to normal, and how I would be able to live any of this down."
    "Maybe it was my imagination, but, in addition to all these changes, Katrina seemed to be treating me strangely as well."
    "She wasn't teasing me nearly as much as usual, for one thing. When she looked at me, her expression seemed... dismissive."
    "I realized a tomboy like Katrina wouldn't have much respect for any girl with my personality type. I had become the very kind of girl that she had always clashed with."

    "Hearing my new name snapped me back to my senses."

    stop music fadeout 2.0
    show kyoko a_6 with exchange
    kyoko "Jane's been quiet all lunch. Did something happen to you?"

    "Before I could speak, Kiyoshi began talking."

    play music bgm_marty_gots_a_plan
    show kiyoshi a_6 with exchange
    kiyoshi "Yes, Jane came over and--"

    show kyoko b_4 with exchange
    show john b_17 with exchange
    john "Shh!"

    show kiyoshi a_1 with exchange
    "I was obvious where he was going, and I could feel the warmth of my cheeks flushing from embarrassment."

    show katrina a_1 with exchange
    katrina "Jane, you didn't tell me you went to Kiyoshi's house last night! What was it like?"

    show john b_16 with exchange
    john "Um... fine..."

    show katrina b_0 with exchange
    katrina "Don't be like that! How was it? What did it look like? Did Kiyoshi have secret alien experiments running everywhere?"

    john "Not really..."

    show katrina a_0 with exchange
    "Kat turned away from me, thankfully, and toward Kiyoshi."

    katrina "So how did your uncle react?"

    show kiyoshi a_4 with exchange
    kiyoshi "He seemed surprised I had a girl at the house, but I have no idea why. No one should underestimate my expertise with women."

    show kyoko a_1 with exchange
    show katrina b_1 with exchange
    "Kat and Kyoko broke into giggling which they were trying hard to hold back."

    show kiyoshi a_3 with exchange
    kiyoshi "What?"

    show kyoko a_9 with exchange
    show katrina b_0 with exchange
    kyoko "Nothing. Go on."

    show kiyoshi a_1 with exchange
    kiyoshi "Yes, and--"

    show john b_7 with exchange
    john "And I went home later."

    "Katrina stared skeptically at me."

    show katrina a_1 with exchange
    katrina "And that's all, huh? I feel like there's more to the story here. C'mon, damn it! Kiyoshi, tell me!"

    show kiyoshi a_5 with exchange
    show john a_6 with exchange
    "Kiyoshi opened his mouth but, looking at me about to fume, thought better of speaking and promptly remained silent."

    show kyoko b_3 with exchange
    kyoko "Kiyoshi... is lost for words? Have we stumbled into a parallel dimension?"

    show katrina a_5 with exchange
    katrina "I don't know about a parallel dimension, but something's definitely off about those two today. I'd better leave before I catch whatever they've got."

    show katrina a_0 with exchange
    katrina "And by that, I mean that I need to use the bathroom."

    show kyoko b_9 with exchange
    kyoko "Oh, oh, let me come too."

    hide katrina
    hide kyoko
    with dissolve
    stop music fadeout 2.0
    show john a_9 with exchange
    show kiyoshi a_0 with exchange
    "Kyoko and Kat stood up and left the table, both clearly bewildered by how we were acting."
    "...Who knows what kind of gossiping they were going to do in the bathroom."
    "When they were out of sight, Kiyoshi then turned to me and began whispering."

    play music bgm_groove_grove
    kiyoshi "I was thinking about how to deal with Jack earlier, and I came to the conclusion that we need help. Yes, we need special skills to aid us in our quest. Perhaps we should have someone else help us?"

    show john a_14 with exchange
    john "Like who? I mean, we {i}could{/i} tell Kat and Kyoko. They don't really have any special talents, but, if we tell them about the device, they might be able to help us with Jack."

    # micromegas: someone should write izuna in at some point and on some route so this choice doesn't come out of nowhere
    show kiyoshi a_1 with exchange
    kiyoshi "Indeed, you're right... But what about Izuna?"

    show john b_12 with exchange
    john "That girl with the sword? How would {i}she{/i} help?"

    show kiyoshi a_2 with exchange
    kiyoshi "You know, by swinging it around at Jack!"

    "Kiyoshi swiped his arms a few times in mock sword-swings."

    john "Eh..."

    show kiyoshi a_1 with exchange
    kiyoshi "Oh, and Maria! She's good at sneaking around and sniffing out things, right?"

    show john b_7 with exchange
    john "Yeah, if by {q}things{/q} you mean {q}school gossip.{/q}"

    kiyoshi "Murder investigation, school gossip... Same difference, I say."

    "I didn't quite agree with any of Kiyoshi's choices, but, giving him the benefit of the doubt, maybe there was some kind of absurd moon logic behind them that I couldn't see."
    "I wasn't even sure why, but I decided I'd at least keep them in mind since I could only come up with {q}tell our friends.{/q} That seemed like a reasonable choice on its face, but doing that might not help us very much in the end."

    menu:
        think "So who would help us the most, I wonder..."

        "{s}I thought telling our friends, Kyoko and Katrina, would be best.{/s}":
            placeholder

        "{s}Izuna had that huge sword, so maybe she'd be able to help us.{/s}":
            placeholder

        "Maria. She could steal Jack's device.":
            routename "I Don't Wanna Be Kissed (By Anyone But You)"
            stop music fadeout 2.0
            show john b_8 with exchange
            john "I guess we'll go with Maria. She {i}does{/i} know how to sneak around and get the goods on people. Maybe it'll work against Jack?"

            show kiyoshi a_2 with exchange
            kiyoshi "Yes, with her on our side, we'll defeat him for certain!"

            show john b_11 with exchange
            john "...Assuming we can even convince her to help us. Let's meet up again after school and go see her then."

            "Though I was much less certain than Kiyoshi about the virtues of Maria's help, we would be more likely to defeat Jack with her on our side than anyone else we could think of."

            "Kiyoshi and I stood up from the table, with me carrying both of our lunch trays and throwing away the garbage without complaints. Waiting for me in the hall, the two of us left for classes together."

            jump legacy_alien_murder_day5_maria

        "{s}I decided we'd do better if we just continued by ourselves.{/s}":
            placeholder

label legacy_alien_murder_day5_maria:
    resetstate
    body john johnGB_legacy

    # micromegas: maybe add a scene with zoey/brad here before maria, so it doesn't seem so 'point a to point b', toward a pre-determined conclusion (even though it basically is at this juncture); also readers may think we've forgotten about them; probably add a scene with jack's class here, too, before zoey, to go along with the murder route
    stop music
    scene black
    with dissolve
    "After last period, Kiyoshi and I met up in the hallway. He apparently had some idea of where Maria's last class was and we ran toward it, him pulling me by the arm like a rag doll."

    "In the classroom, there were only a few students shuffling around, picking up their papers, textbooks, pencils, and so on. Maria was fiddling around with her camera."

    scene bg school classroom_3 day
    accessory maria set camera
    show maria a_2 at right
    show kiyoshi a_0 at centerleft
    show john a_3 at left
    with dissolve
    play music bgm_investigations

    maria "Come! On! Stupid thing!"

    "Kiyoshi and I approached her hesitantly."

    show john a_10 with exchange
    john "Maria?"

    show maria at faceleft with exchange
    "Maria took a glimpse at us and then quickly returned her attentions to her camera."

    show maria a_5 with exchange
    maria "Oh, it's you and that freak. What do you want?"

    "Kiyoshi leaned over and whispered to me."

    show kiyoshi a_0 with exchange
    kiyoshi "Let me do the talking. It's obvious she's... negatively predisposed toward you."

    show john a_8 with exchange
    john "Kiyoshi, I think it's--"

    show kiyoshi a_1 at center with ease
    kiyoshi "O fair damsel, we have come to ask for your help in our battle against evil."

    show maria a_2 with exchange
    maria "Piss off, pervert!"

    show kiyoshi a_4 with exchange
    kiyoshi "Hmm, maybe I should try a more effective strategy..."

    show kiyoshi a_1 at centerright with ease
    "He bent down on one knee and took her hand and kissed it. For a moment, she was too stunned to react."

    kiyoshi "Please kindly render us succor, o Queen of Rumor."

    accessory maria clear
    play sound sfx_whack
    show kiyoshi:
        anim_fall_over_left
    with hpunch

    "Recovering from her shock, Maria smashed him on the head with her camera, knocking him to the floor."
    hide kiyoshi

    # TODO: camera sfx
    show white
    hide white with Dissolve(0.3)
    "Suddenly the flash went off."

    show maria a_0 with exchange
    maria "Yes, it's working! Guess you're finally good for something, Kiyoshi."

    "I kneeled next to Kiyoshi, still on the ground and disoriented by the attack."

    show john b_17 with exchange
    john "Are you alright?"

    "My heart was beating faster. Although I didn't want my true feelings to come across, my wavering voice betrayed my concern."

    show kiyoshi a_1 at center
    with dissolve

    "Kiyoshi jumped up immediately and patted me on the head. All the anxiety melted away, replaced with a deep sense of calm."

    show kiyoshi a_3 with exchange
    kiyoshi "You have to help us, Maria! There's a murderer on the loose, {i}teaching in this very school building,{/i} and he has a dangerous weapon!"

    "As I was standing up, Maria glanced over at me."

    show maria a_5 with exchange
    maria "What's your boyfriend here blabbing about?"

    show john a_10 with exchange
    john "It's true. Jack Mallory has a device that can alter reality, and change people's bodies and minds. And he's killed before."

    show maria a_0 with exchange
    maria "I'm not sure if I can believe all that..."

    show john b_9 with exchange
    john "You have to! In fact, we have one as well."

    "I took out the device."

    show maria a_5 with exchange
    maria "Looks like a TV remote. How do you even use it?"

    show kiyoshi a_0 with exchange
    kiyoshi "You would normally press one of the buttons on the device to use it, but, unfortunately, I had to use all of its power earlier for an important task..."

    "Maria sighed and shook her head."

    show maria a_2 at faceright with exchange
    maria "Yeah, 'kay, guys, very funny, but I'm not stupid, you know. Bye now."

    show john b_17 with exchange
    john "Wait, you've got to help us! Please! We'll even give you something in return if you do!"

    show maria a_0 at faceleft with exchange
    maria "You're that serious about it? Fine. But I want something good."

    show john a_16 with exchange
    john "Like what?"

    maria "Some juicy gossip, of course! Something I haven't heard before."

    show john a_15 with exchange
    john "..."

    show kiyoshi a_1 with exchange
    kiyoshi "Oh, I know something!"

    show john a_0 with exchange
    think "Thank goodness..."

    show maria a_1 with exchange
    maria "'Kay, spill the beans. What is it?"

    stop music fadeout 1.0
    show kiyoshi a_2 with exchange
    kiyoshi "Jane and I slept together last night."

    show john b_24 with exchange
    john "Kiyoshi!"

    play music bgm_groove_grove
    show maria a_3 with exchange
    maria "Wow! That is news! I don't completely believe you. I have to say, though, the look on Jane's face tells me otherwise."

    "She then took a photo of my blushing, beet-red face."

    show maria a_0 with exchange
    maria "But you'll need to show me the goods."

    john "We're... we're not doing anything like that in front of you!"

    "She started giggling."

    maria "You don't have to go {i}that{/i} far. I couldn't print it anyway. Kiyoshi having any kind of contact with a girl is news enough. I'd just need a pic of you two kissing."

    show kiyoshi a_1 with exchange
    kiyoshi "Can do!"

    show kiyoshi:
        faceleft
        ease 0.3 xcenter 0.25
    show john a_6 with exchange
    john "No, can't, mmmh--"

    show kiyoshi:
        xcenter 0.25
    "Kiyoshi planted his lips on mine and began working his tongue into my mouth, between my closed lips. I struggled for a moment against him before just giving in to the feelings of the moment, opening my mouth and letting him do what we wanted."

    # micromegas: assuming this all works, will continue later; any cg for the "jane" character and a kissing scene?
    "As his tongue met mine in my mouth, I abandoned any pretense of struggle and joined in the kiss, pushing my own tongue against his. I closed my eyes and held Kiyoshi closer, feeling a damp heat from my crotch."

    # TODO: camera sfx
    show white
    hide white with Dissolve(0.3)
    "Suddenly there was a flash of light."

    show john a_9 with exchange
    show kiyoshi:
        ease 0.5 xcenter 0.4
    "Kiyoshi then let go of me, and I wiped my moist lips of the saliva dribbling down them. Maria snickered, looking at the photo she'd just taken on the camera's screen."

    show kiyoshi:
        faceright
        xcenter 0.4
    show maria a_1 with exchange
    maria "Oh, this is {i}good...{/i}"

    "She looked back up at us with a satisfied look on her face."

    show maria a_0 with exchange
    maria "Yeah, I'll help you guys, if you really want it {i}that{/i} bad. I don't really believe your story about that TV remote, or him murdering somebody, but I'll take it from Jack anyways, I guess. It won't hurt him."

    "Maria glanced at her camera's screen again and grinned wickedly."

    show maria a_1 with exchange
    maria "Wanna see? I think it gives a good idea of your... relationship."

    show kiyoshi:
        easeout 0.4 xcenter 0.5
        easein 0.4 xcenter 0.4
    show john:
        pause 0.2
        easein 0.3 xcenter 0.35
        easein 0.2 xcenter 0.2
    "Kiyoshi began walking over towards her, but I yanked his collar before he could make more than a few steps."

    show kiyoshi:
        xcenter 0.4
    show john:
        xcenter 0.2
    show maria a_0 with exchange
    maria "Well, fine. It'll be in the school paper in a few days, anyways, so you can see it then."

    "She giggled and stowed away the camera in her backpack."

    maria "I'll go search for your remote or whatever. Can I take a picture of it?"

    show john a_10 with exchange
    john "Oh, sure."

    show john a_19 with exchange
    "I held up the device and, without realizing it, smiled for the camera."

    # TODO: camera sfx
    show white
    hide white with Dissolve(0.3)

    show maria a_1 with exchange
    maria "How adorable."

    show maria a_0 with exchange
    maria "Anyways, meet me tomorrow about twenty minutes before school in that passageway near the back of the school. I'll give you guys that remote or whatever, if I find anything."

    hide maria with dissolve

    "Maria left the classroom, glancing back at us and starting to snicker again before reaching the door."

    stop music fadeout 2.0
    show john a_17 with exchange
    john "God, what have we done..."

    show kiyoshi a_2 with exchange
    kiyoshi "We've completed our quest and gained the aid of Maria. Now we'll surely defeat Jack!"

    hide kiyoshi with dissolve

    "Kiyoshi marched out of the room triumphantly, and I began to follow behind him, feeling enervated from the kiss, as if Kiyoshi had somehow sucked out some part of me."

    "And, with how I'd been acting the last two days, it was starting to seem that way."

    jump legacy_alien_murder_day5_afterschool

label legacy_alien_murder_day5_afterschool:
    resetstate
    body john johnGB_legacy

    scene bg school entrance dusk
    show kiyoshi a_1 at centerleft
    show john a_7 at centerright, faceleft
    with Fade(0.5, 1.5, 0.5)
    play music bgm_easy_lemon

    "Leaving school behind with Kiyoshi, I realized that I still wasn't able to return home. I tugged weakly at his sleeve to get his attention."

    show kiyoshi a_1 with exchange
    kiyoshi "Oh, what is it?"

    john "Now what?"

    show kiyoshi a_3 with exchange
    kiyoshi "I planned on heading home and getting something to eat, and maybe reading up more on the post-nuclear alien invasion later."

    show john a_10 with exchange
    john "Yeah, but what about me? I still can't go home like this..."

    show kiyoshi a_2 with exchange
    kiyoshi "Oh, you know me. I always think ahead. I went by your house and zapped your family this morning before I went to school."

    show john b_24 with exchange
    john "K-Kiyoshi...!"

    show kiyoshi a_1 with exchange
    kiyoshi "Of course, you could always come home with me again tonight."

    if fGirlAcceptance:
        show john a_17 with exchange
        john "I..."

        "I did sorta want to go with him, but, based on last night, I was pretty sure what would happen if I did. The part of me that was a girl was dying to go with him, but the part of me that was a guy seemed to be screaming {q}no, don't do it!{/q}"

        menu:
            "In the end..."

            "I went with Kiyoshi.":
                # micromegas: after this is kiyoshi's house and a sex scene, according to the outline; supposedly phido's responsible for those so i'll leave it be
                "My face felt on fire as I looked at Kiyoshi."

                show john a_10 with exchange
                john "I'll go with you..."

                show kiyoshi a_2 with exchange
                kiyoshi "I knew you couldn't resist my charms! Let's go!"
                stop music fadeout 2.0
                scene black
                with wipeblinds_horiz
                pause 1.0
                jump legacy_alien_murder_day5_sex
            "I decided I'd go back home by myself.":
                # TODO: micromegas: in some earlier part of either day 4 or 5, he or kiyoshi (the latter, probably) will need to use the device on mom/sister such that they're convinced he's always been jane, too; can be off-screen but needs to be clear; maybe put it with the other day 5 morning mental changes; also scene here assumes sex day before, but the maria scene already does anyway

                # micromegas: this choice wasn't outlined in any detail because of assumptions for the murder route, so will probably require other resolutions/notes/dialogue in other parts of the script, and revisions/additional writing for these scenes

                $ fGirlAcceptance = False
                think "No, I can't. If I go with him, I'm going to give in. With this overly feminine mind Kiyoshi gave me, I wouldn't be able to resist..."

                show john a_17 with exchange
                john "Sorry, Kiyoshi, I can't..."

                "Part of me was crestfallen at having to turn him down--the girly part I'd denied--but the part of me still a guy felt overwhelming relief. My downcast eyes betrayed only the former, though."

                show kiyoshi a_2 with exchange
                kiyoshi "No problem! I think we both need a little break after yesterday."

                "Kiyoshi grinned slightly but spoke with a vague tone of disappointment."

                show kiyoshi at faceleft with exchange
                pause 0.2
                hide kiyoshi with moveoutleft
                "As he started home, I had to stop myself from calling out to him, catching the words in my throat before I could say them."
    else:
        show john b_10 with exchange
        john "...I think I'd rather just go home."

        kiyoshi "Suit yourself. But don't come crawling back to me when you need to know how to work a Geiger counter."

        show kiyoshi at faceleft with exchange
        pause 0.2
        hide kiyoshi with moveoutleft


    # micromegas: could use streets for bg, but this is mostly standard "changes happened today" navel-gazing/recap stuff
    scene black
    with fade
    "On the way home, while thinking about Kiyoshi and what had happened over both today... and the night before, I realized how used to the sensations of being a girl I had become."
    "To the two breasts bouncing in front of me and their unbalancing weight, to my longer legs and thicker thighs whose soft skin brushed against each other, to my shorter stature and the feelings of helplessness that came with it, to the skirt flapping around my legs with each step and the tight leggings encapsulating them."
    "Everything was different, but none of it was bothering me anymore as something {i}truly{/i} different. I didn't even regard any of the sensations as new unless I concentrated on one of them."
    "Being like this seemed more and more to erode who I was before, replacing it with this substitute, this idea of a person, of a woman, one who wasn't at all like me yet {i}was{/i} me. Thinking about it depressed me. I almost wanted to cry, but I knew even that would be allowing that other, that new part of me, to have her way."
    "It was almost Kafkaesque, as if, instead of waking up a giant insect, I woke up inside a different person, with her own ideas and feelings. And by them who I {i}was{/i} had slowly merged into that person, and {i}I{/i} was becoming indistinguishable from her."
    "I tried to shake off the idea I was losing some part of myself, but the fact was inescapable. I had to resolve to myself that tomorrow, everything would be fixed."

    "Arriving at home, Mom and Holly treated me like my normal (female) self. Holly, still impassive, my mom, still cheerful. Mom had the impression I enjoyed helping with dinner and household chores, part of the change in personality to Kiyoshi's {q}feminine ideal,{/q} and gave me a few things to do when I got home."

    # micromegas: could probably add scenes of some of the things below rather than tell about them, but leaving it at this for now; unsure which would be more effective; readers might just want to reach the ending, being close already; cooking scene with mom might be nice, though

    "And, honestly, I did enjoy doing them: cooking a meal for Mom and Holly, vacuuming the halls, and doing the dishes. As long as I didn't think about whether something I did was {i}truly{/i} me or not, I could enjoy my time at home and with them."

    scene bg house_davis bedroom_john night
    with dissolve

    "Back in my room, I lay down on my bed and sighed deeply."

    play sound sfx_knock
    "Suddenly, there was a knock at the door."

    show john a_16 at centerright, faceleft:
        yanchor 0.0
        easein 1.0 yanchor 1.0

    john "Who is it?"
    show john at centerright, faceleft with exchange

    sandra "It's a mysterious stranger!"

    john "Oh, come in, Mom."

    play sound sfx_door_open
    show sandra a_0 at centerleft with moveinleft
    "The door opened, and my mom walked in. I rose from the bed. Looking at my room for a second, my mom's eyes then widened as she seemed to remember something."

    # micromegas: instructions for device say clothing is changed, but not sure if it was intended to be "only the clothes on a person are changed" or "all the clothes a person has are changed"; assumed the former
    # if mom changed, then she'd probably notice clothing at some point; the script outline for murder assumed going to kiyoshi both nights, so no hint as to how the clothing issue would be resolved for family's (possible) mental changes with device

    show sandra a_2 with exchange
    sandra "Oh, you know, somehow it slipped my mind earlier, but the strangest thing happened when I was going through your clothes earlier today: they're all men's clothing."
    sandra "...Do you have any idea what happened?"

    think "This isn't good..."

    show john a_17 with exchange
    john "Umm... No idea?"

    show sandra a_1 with exchange
    sandra "Well, I went out and bought a few outfits and underwear for you while you were gone. Hopefully they'll work until I can take you to the mall with me and we can get you a new wardrobe."

    think "I definitely need to change things back before {b}that{/b} happens."

    show john b_12 with exchange
    john "Thanks Mom..."

    show sandra a_0 with exchange
    sandra "Still, I wonder how that happened... Nothing else was taken, only your clothes, and whoever stole them bothered to replace them. Maybe some kind of weird pervert is on the loose?"

    show john b_16 with exchange
    john "Maybe..."

    sandra "Anyway, have a good night, sweetie."

    show john a_3 with exchange
    john "...You, too, Mom."

    # micromegas: could insert a bath/shower scene around here, either before or after conversation; will wait to see if cg exists first, though doubtful; can be written without cg, however, just needs proper bg: bathroom 2/3 might work, but i believe bathroom 1 was used before for john's house

    hide sandra with moveoutleft
    play sound sfx_door_close
    stop music fadeout 2.0
    "Shutting the door behind her, she went with light footsteps back downstairs. I got up from the bed, looked at the bag of clothing she'd brought me. For a moment, I wanted to try on the clothes, but I shook the idea out of my head and just turned off the lights."

    scene black
    with dissolve
    "I took off my school uniform, leaving me in only my bra and panties, and hopped into bed, my breasts jiggling in their cups as I hit the covers. Tucking myself in, I closed my eyes and fell asleep."

    jump legacy_alien_murder_day6

label legacy_alien_murder_day5_sex:
    scene bg house_honda livingroom dusk
    show john b_5 at centerright, faceleft
    show kiyoshi a_1 at centerleft
    with wipeblinds_horiz
    body john johnGB_legacy
    play music bgm_summer_day

    "Kiyoshi and I arrived at his house with the sun setting. It appeared that no one was home tonight."

    john "Where's your uncle?"

    show kiyoshi a_2 with exchange
    kiyoshi "He's at work tonight."

    show john b_12 with exchange
    john "Oh..."

    "We put away our things from school, and I started looking through his pantry for something to cook."

    john "What do you want?"

    show kiyoshi a_1 with exchange
    kiyoshi "We can just order something. You don't have to cook tonight."

    "I nodded."

    show black
    with diamonds

    show john b_14 with exchange
    "After ordering take-out, we stole glances at one another, a palpable tension between us."

    kiyoshi "So... pretty crazy couple of days, huh?"

    john "Yeah."

    hide black
    with wipeclock

    show john b_9:
        ease 1.0 yanchor 0.85
    show kiyoshi a_1:
        ease 1.0 yanchor 0.85
    "When the food arrived, we sat and ate in silence."

    show john:
        yanchor 0.85
    show kiyoshi:
        yanchor 0.85
    "Kiyoshi finished his food while I was still eating, and he began cleaning the table of his dirty dishes."

    show kiyoshi:
        ease 0.5 yanchor 1.0
        ease 1.0 right
    pause 1.0
    kiyoshi "Are you almost done? I have something to show you."

    show kiyoshi:
        yanchor 1.0
        right
    show john b_13 with exchange
    john "Yeah, just finishing."

    stop music fadeout 2.0
    show kiyoshi:
        faceleft
        ease 0.5 xcenter 0.8
    "Kiyoshi's hands reached from behind me. He grabbed the bottom of my chin and forced me to look up."

    play music bgm_blue_feather
    show john b_17 with exchange
    show kiyoshi:
        xcenter 0.8
    "Kiyoshi stood above me, lowering himself for a kiss. I didn't resist."

    "He kissed me gently. I wriggled in his arm, unsure what to do, but he held onto me too tightly for me to remove myself from his embrace."

    "As I moved, Kiyoshi's hand settled on my breast, teasing and manipulating it through the fabric. My entire body responded."

    "His lips still on mine, I let out a small whimpering moan."

    "His hands then unbuttoned the top of my uniform, revealing my cleavage."

    "Kiyoshi's hand wormed its way through the opening in top, and slid itself between my bra and one of my breasts."

    "He dragged down my top and bra, releasing my breasts from my shirt and bra, baring them to the world."

    "I tried to say something in protest, yet..."

    "This was what I wanted. I threw myself completely at him."

    show john b_24 with exchange
    "Between my legs I started feeling damp, my womanhood preparing itself."

    "Kiyoshi slowly traced a finger around my areola until reaching the center, slightly pinching my nipple."

    "Kiyoshi began planting kisses on my neck. I closed my eyes and moved my head to the side."

    show john:
        ease 0.5 yanchor 1.0
    pause 0.5
    scene black
    with wipeup
    "As I stood up, Kiyoshi surprised me and instead swept my feet from underneath me, and he picked me up."

    john "Am I really that light now?"

    "Kiyoshi seemed slightly winded."

    kiyoshi "Yeah, as a... {i}huff...{/i} feather!"

    "Kiyoshi laid me down on the couch. I tried to preserve my modesty and cover the underside of my skirt, but Kiyoshi grabbed my legs and ripped the crotch of my pantyhose."

    john "H-Hey!"

    scene cg johnGB sex face_0 semen_off
    with diamonds
    "My protests died in my mouth as he pushed my panties aside with a primal light in his eyes. He held my legs open and plunged his manhood into my pussy."

    "I gasped as I felt my vagina lubricating more every time he pushed himself into me."

    "In the back of my mind, the guy inside was telling me {q}you shouldn't want this,{/q} {q}this is your best friend,{/q} and {q}you need to stop it now.{/q}"

    "Yet what I felt contradicted those feelings completely. My lips were partly opened. Every time I breathed out, I couldn't help but let out small, happy sounds, as if affirming how I was--and how I would be."

    "Kiyoshi seemed to be getting into it more and more with every sound from my mouth."

    show cg face_2

    "With one deep movement, my lips parted in a moan, and my pussy clinched down on Kiyoshi's cock further."

    "Kiyoshi reached down and began teasing my clit, making me squirm beneath him. He smiled a little whenever I wriggled at the slightest touch of his finger."

    kiyoshi "Are you enjoying that, Jane?"

    "He pinched it."

    john "Aaahnn! Yes, more!"

    "He squeezed it again, along with my nipple in his other hand. I tried biting down on my lip to stop myself, but there was no controlling my response now. This body was too sensitive and my mind too girly to respond any other way."

    show cg face_1

    "I couldn't hold it in any longer and screamed out in pleasure, and I started pushing against Kiyoshi with each thrust."

    john "Harder, Kiyoshi!"

    "He hugged me tightly, squishing my large tits against his chest, exciting me more as my nipples kept rubbing against him."

    "I felt strangely helpless, like a puppet to my own desires, and, under him, I felt completely subject to him, to what he wanted."

    "But I didn't hate it. I actually {i}enjoyed{/i} being like this. I wanted to please him, to make him as happy as I was feeling now."

    show cg face_2

    kiyoshi "I love you, Jane!"

    john "I love you, too!"

    "I responded without any hesitation or waver in my voice. Regardless of the reasons, I did really love him and I wouldn't bear having it any other way."

    kiyoshi "I'm close!"

    show cg semen_on with dissolve
    "My limbs electrified as a warmness filled my pussy."

    stop music fadeout 3.0
    scene white
    with CubeCloudsTransition(2.0)
    scene black
    with fade

    "Kiyoshi pulled himself out of me and plopped down next to me with a satisfied smile. I was smiling, too. I felt as if I was melting to goo from the deep contentment inside me."

    think "If this is what being a girl feels like, I don't..."

    think "...I don't think I want to go back to being a guy."

    "I wanted to push that thought away, but it recurred continuously, a persistent, undeniable thought: {q}I don't want to go back to being a guy.{/q}"

    "I looked back at Kiyoshi. He started to open his mouth, but it seemed he didn't know what to say, or how to say what he wanted to say. After minutes of silently staring at each other, Kiyoshi finally managed to speak."

    kiyoshi "Did you mean it when you said you loved me?"

    john "I... I did."

    kiyoshi "I've never had a girl say that to me before."

    john "Oh..."

    "Kiyoshi began to blush."

    kiyoshi "And, well, um... also, I meant it, too..."

    "I felt the urge to kiss him at that moment but restrained myself as he started speaking again."

    kiyoshi "That's, uh, all, I guess... Goodnight... Jane."

    "I giggled and gave in to the urge, briefly kissing him on the lips, making his cheeks turn even redder."

    john "Goodnight, Kiyoshi."

    "As I fell asleep, a vanishing part of me regretted what happened, how I gave in to the mental programming, but the joy I felt dwarfed that part easily."

    "I knew I was changing, that I had changed, but I didn't care. If changing meant feeling like this more, I wanted to change."

    jump legacy_alien_murder_day6
