label legacy_alien_mariamania_day4:
    routename "Deus Sex Machina"

    if not _scenario:
        "This is the Maria Mania route featured in Student Transfer until Version 9.0."
        "John only intended to impart Maria's plethora of relationship knowledge into Zoey's mind alone, but Mr. Butterfingers here winds up causing a cataclysmic Maria-fication event instead. Oops."
        "This route was written back when we were considering the implementation of {q}short ends.{/q} Miniature routes that were never meant to last more than a day or two, as a lighter contrast to the feature-length paths. However, the scope of Maria Mania wound up bloating beyond the author's intention as it became apparent wrapping the story up in just a single day was a disservice to the characters."
        "This left it in a purgatorial space between silliness and seriousness that made it difficult to continue without stretching itself thin, and so per the author's request we have since removed it from the main game and converted it into a scenario."
        "Before we begin, though, there's a small detail to address: If John chose to steal Yui's knowledge for the math exam earlier in the day, the Maria Mania route ends before it can begin. It's a small piece of content, but we've preserved it along with the main body of the route."
        menu:
            "Did John steal Yui's math exam knowledge?"
            "Yes. (This will end the scenario very quickly.)":
                $ fYuiCheat = True
            "No. (This will allow the scenario to play out in full.)":
                pass

        scene bg school cafeteria
        show john a_2 at centerleft
        show katrina a_0 at left
        show kyoko b_5 at right, faceleft
        show zoey a_6 at center, faceleft
        with fade

        play music bgm_vivacity

    "Of all the options available, using the memory copy function seemed like the best way to get to the root of the problem."

    show john a_5 with exchange
    think "If she had a better understanding of how relationships actually work, maybe she'd be able to get over her crush a bit easier? At the very least, she'd be better at handling these kinds of situations with a little more tact than she does now."

    "As soon as I started to think of who might fit the bill for a subject to copy, it came to me almost immediately."

    show john a_0 with exchange
    think "What if I gave her some of Maria's knowledge on these things? She writes a weekly couples column in the school paper, and she's been with Eric for as long as I can remember, so she has to at least know {b}something{/b} more than Zoey does."

    "Having made up my mind, I excused myself from lunch and headed out into the empty hall."

    scene bg school hallway_2 day
    with fade

    play music bgm_covert_affair

    "If I wanted a good chance at using the device on Maria without anybody seeing, the lunch period was about as perfect as I could ask for."

    "She and Eric were probably off in their usual spot right now, and with nobody in the halls I could use the device without fear of being seen."

    scene bg school passage day
    with fade

    "Once I made it outside, though, it was clear that neither Eric nor Maria were here any more. Instead I was met with a still-smoking cigarette butt lying on the ground."

    think "Odd, there's still a good bit of lunch period left, and I didn't see them anywhere on the first floor, either. They must've been here recently, though, so I can't imagine they went too far."

    "I circled back around and into the school again, hoping for better luck on another floor."

    if fYuiCheat:
        jump legacy_alien_mariamania_day4_stairs_yui
    else:
        jump legacy_alien_mariamania_day4_stairs_maria

label legacy_alien_mariamania_day4_stairs_yui:

    scene bg school hallway_2 day
    show yui b_1 at centerright, faceleft
    show john a_5 at offscreenleft
    with fade

    show john a_5:
        ease 1.5 centerleft

    stop music fadeout 2.0

    "Unfortunately, I hadn't even fully cleared the door frame before I found myself face-to-face with an unexpected guest."

    yui "John! What were you just doing outside?"

    show john a_2 with exchange

    think "Great."

    "She seemed to be coming out the gates at full speed this time, not even waiting for an explanation before continuing."

    show yui a_2 with exchange
    yui "You should be in the cafeteria right now, not freely wandering the school grounds! Maria and Eric didn't surprise me, but I {b}know{/b} you know better!"

    show john a_15 with exchange
    "She seemed more than a few degrees past agitated--in fact, probably more exasperated than I'd ever really seen her."

    john "Whoa, everything's okay, Yui! Just chill!"

    show yui a_3 with exchange
    yui "I--"

    show yui a_5 with exchange
    "She stopped herself, and I watched her shoulders visibly un-tense a bit as her frustration dissipated."

    show john a_5 with exchange
    yui "I'm sorry, John. I..."

    yui "I shouldn't have snapped at you."

    show yui b_3 with exchange
    yui "Today's just been... no good."

    yui "I had to get onto two students for conducting inappropriate acts outside {i}yet again,{/i} and I haven't gotten to eat yet, and earlier I..."

    show john a_16 with exchange
    "As she trailed off, I almost felt the urge to say {q}That's still no excuse to take it out on me{/q} before I realized what she had almost listed off next."

    show john a_5 with exchange
    think "That she just failed our math test. The test {b}I{/b} just aced thanks to her stolen memories."

    show john a_2 with exchange
    "The fact that I had felt so {i}smug{/i} when I did it only made me feel even worse. I had thought of it as a little bit of revenge for all the trouble she'd given me over the years, but it was obvious now that the test had gotten to her more than I was willing to acknowledge."

    think "...Yeah, maybe that {b}is{/b} a good excuse to take it out on me."

    show john a_5 with exchange
    john "You're right, Yui. I shouldn't have been walking around outside during lunch."

    show yui a_5 with exchange
    yui "I... Thank you."

    show yui a_0 with exchange
    "She gave me a weak smile, but she was clearly still pretty downtrodden."

    yui "Just... please don't do it again, okay? If you head back to the cafeteria now I'll pretend this never happened."

    "A part of me wanted to try and sneak my way out of this, stick with my plan to fix the Zoey problem... but my guilt was more than enough to bury that thought."

    show john a_6 with exchange
    john "Of course."

    hide yui
    with dissolve

    "Yui gave me one last smile as I headed back towards the cafeteria."

    show john a_5 with exchange
    "For now, my plan for Zoey would have to wait. I'd see if I could find any better uses for the device until the next time that problem reared its head. It certainly wasn't a rush, in any case."

    show john a_6 with exchange
    think "Well, maybe it {b}is{/b} still a rush to Kiyoshi."

    scene bg school cafeteria
    show john a_5 at centerleft
    show katrina a_2 at left
    show kyoko b_3 at right, faceleft
    with fade

    "By the time I made it back to our table, I found Katrina and Kyoko sitting in silence, simply picking away at their food."

    "Kyoko didn't surprise me, given her current mood, but with Katrina having a similarly gloomy look about her I had to guess that she'd probably prodded a hair too much while I was away."
    #Assuming this lines up with the Day 4 skeleton, the segment where John normally prodded a bit in regards to Kyoko's mood is now something Kat did in his absense, meaning that he's only coming in for the aftermath. Now we're back in sync with Skeleton and good to go.

    if not _scenario:
        placeholder
    else:
        jump alien_day4_lunch_end

label legacy_alien_mariamania_day4_stairs_maria:
    scene bg school stairwell_1_flip day
    with fade

    "Sure enough, as I made it up the stairs and reached the second floor of the school, I could hear muttered tones echoing through the hall from a pair of distinctly low and high voices."

    #note for future me/someone who has better ideas than me: This upcoming segment seems like an opportunity for some Maria/Eric comedy gold, but for now I'm just playing it extremely straight and simple to keep things moving

    show bg:
        parallel:
           ease 0.5 zoom 1.3
        parallel:
           ease 0.5 xpos 0.4
        parallel:
           ease 0.5 ypos 0.4

    #all of this in smol
    maria "{size=-5}... just doesn't know when to chill out! I swear, that girl needs to get laid, {i}bad.{/i}{/size}"

    eric "{size=-5}It's fine, at least she's out of our hair now.{/size}"

    eric "{size=-5}And for some reason, babe, I have a feeling she isn't the only one who needs it...{/size}"

    show bg:
        parallel:
           ease 0.5 zoom 1.0
        parallel:
           ease 0.5 xpos 0.5000001
        parallel:
           ease 0.5 ypos 0.50000001

    "The conversation seemed to stop there, and I had one guess as to why."

    think "Let's... not think about this too much."

    "Putting aside my slight discomfort, I made my way further down the hall, doing my best to keep quiet and not draw attention to myself."

    scene bg school hallway_1_flip day
    with dissolve

    "As I reached the end of the hall, my suspicions were all but confirmed: the two were locked in what might have been the most intense makeout session I'd ever seen."

    "The last thing I wanted to be here was a spectator, so I took no time to pull out the device and prepare my command."

    #"I thought about copying Maria's experience with relationships, and pressed the corresponding button to store them on the device."
    #suggestion from Vuan to follow up on: make this command less nebulous, and instead play off of the fact that John doesn't actually know what exactly TO copy. It explains the impartial/imperfect copying we get later on

    think "...What {b}is{/b} the right command here?"

    "I realized pretty quickly that I couldn't just copy Maria's relationship memories wholesale. The last thing I wanted was for Zoey to suddenly think she was dating Eric."

    think "What exactly am I supposed to copy, then? I know Maria's good about these things, but it's not like I have a checklist here to go through the reasons {b}why{/b} she is."

    "I didn't want to admit it, but my complete inexperience with relationships probably made me a bad judge of what was worth copying in the first place."

    think "Okay... Well, if her column's anything to go by, Maria's probably more open to talking about relationships and romance than anyone. That might be helpful to copy."
    #translates to: open about sex and dating

    think "She also seems like she's always trying to matchmake, and from what I've seen she's actually pretty good at it. That'd come down to being able to tell how compatible people are, right?"
    #translates to: Yui and Kat zeroing in on John, given the circumstances

    think "Having a good idea of what works and what doesn't in a relationship is probably something she'd know too, so I guess that'd come down to... general romantic knowledge?"
    #translates to: physical experience, flirting/teasing knowledge, and general tips (AKA things like Wanda articles and Kyoko's newfound assuredness in birth control)

    think "That'd probably tie into knowing what you want out of a relationship, too. I'm not even sure if Zoey knows {b}why{/b} she wants to date Kiyoshi, so that one might be important."
    #translates to: the cases that Yui and Kat present to John

    think "...What else is there? I feel like there should be more, but if there is I'm the last person who would know."

    "With my mind drawing a blank, there wasn't much left to do besides issue the command and make the copy."

    "I pointed the device towards Maria, thought about copying everything I had just run through, and pressed the corresponding button to store them on the device."

    play sound sfx_device
    "I heard a small click and whirl from the device in response, but beyond that there was little indication that the copy had been a success."

    "Either way, I had no interest in sticking around here any longer. I took my opportunity to sneak back down the hall and toward the stairs I had come from."

    scene bg school stairwell_2 day with dissolve:

       zoom 1.5
       xpos -0.4
       ypos -0.4
    #show john a_0 at offscreenright, faceleft

    show john a_0 at center, faceleft:
        xpos 1.2
        ease 2.5 xpos 0.67

    if fConnieCheat:

        "As I continued along the bend to the stairwell, I took a moment to look at the device again. The last time I had used one of the memory functions, I didn't have anything stored in it long enough to look for an indicator of some kind."

    else:

        "As I continued along the bend to the stairwell, I took a moment to look at the device again, curious if there was any visible indication that the memory function had been used."

    "If there {i}was{/i} supposed to be anything showing that Maria's memories were in there, I certainly wasn't seeing it."

    think "Well, even if I didn't get it, it wouldn't be hard to track down Maria again. I'd just need to make sure--{w=0.5}{nw}" #auto-skip

    stop music fadeout 2.0

    show john a_0 at faceleft:
        xpos 0.67
        ypos 0.542
        xanchor 0.5
        yanchor 0.5
    yui "John? Why are you--{w=0.4}{nw}"

    show yui b_6 at centerleft, faceright:
        alpha 0.0
        xpos 0.2
        ypos 0.59
        yanchor 0.5
        xanchor 0.5
        parallel:
            ease 0.4 alpha 1.0
        parallel:
            ease 0.6 xpos 0.4

    show john a_4 with exchange
    think "Yui!?{w=0.4}{nw}"

    init python:
      spline1 = SplineMotion([
        ((0.30703125, 0.44583333333333336),),
        ((0.13046875, 0.6666666666666666), (0.20390625, 0.4666666666666667), (0.14921875, 0.5527777777777778)),
        ], 0.6, anchors=(0.5, 0.5), repeat=False)

    show john a_4:
         faceleft
         parallel:
              ease 0.7 xpos 0.3
         parallel:
              ease 0.7 ypos 0.7

    play sound sfx_whack

    show yui b_2 at spline1:
        alpha 1.0
        ease 0.6 rotate -15
    with hpunch

    #show yui:
        #alpha 1.0
        #anim_fall_over_left
    #show john a_4:
        #anim_fall_over_left
    #with hpunch
    play music bgm_all_this

    "Before I even knew what was happening, Yui was falling backwards from the impact, stumbling as her foot failed to find the top stair."

    show john a_4:
        xpos 0.3
        ypos 0.7

    "Instinctively, I dashed forward and threw my arms out to catch her."

    $ renpy.music.set_volume(0.0)

    show john a_4:
         parallel:
              ease 1.0 ypos 0.542
         parallel:
              ease 1.0 xpos 0.48

    show yui b_2:
         rotate -15
         xpos -0.08
         ypos 0.26
         parallel:
              ease 1.0 ypos 0.073001
         parallel:
              ease 1.0 rotate 0
         parallel:
              ease 1.0 xpos 0.1
    "Both of my hands found a firm grip on Yui's shoulders, and I immediately pulled against my momentum to try and right the two of us."

    show john a_5 with exchange
    "By the time we were both on solid footing again, I found myself staring face to face with a wide-eyed Yui. Even with my hands resting on her shoulders I still felt a bit unbalanced, adrenaline pumping and heart racing."

    show john a_5:
         ease 1.0 xpos 0.7
    "In between our heavy breaths, I could hear the sound of something clacking down the stairs in the distance."

    $ renpy.music.set_volume(1.0)

    show john a_15 with exchange
    think "...The device."

    think "...I threw the device."

    think "I {b}threw{/b} the device."

    "As my brain finally began to register what had just happened, I felt a wave of panic wash over me. It must've shown on my face, as Yui's expression shifted from one of shock to one of concern."

    scene bg school stairwell_2 day:

       zoom 1.5
       xpos -0.4
       ypos -0.4

    show yui b_2 at center, faceright:
         xpos 0.393
         yanchor 0.995

    show john a_15 at center, faceleft behind yui:
         yanchor 1.0
         zoom 1.0
         xpos 0.70
         parallel:
             ease 1.0 xpos 0.3
         parallel:
             ease 1.0 zoom 0.9
         parallel:
             ease 0.3 yanchor 1.0
             ease 0.3 yanchor 0.98
             repeat
    pause 0.5

    hide john a_15 with dissolve
    "Without even thinking, I sidestepped her and ran down the stairwell in pursuit of the device. I think Yui might have called after me, but it barely even registered in my mind."
    #by the way she's totally telling him not to run down the stairs

    scene bg school stairwell_1 day with dissolve:

         zoom 1.5
         xpos -0.5
         ypos 0.000001
         parallel:
              ease 2.0 zoom 1.0
         parallel:
              ease 2.0 xpos -0.00000001

    play sound sfx_running

    show john a_15 at center, faceleft:
         alpha 0.0
         xpos 0.9
         zoom 0.8
         yanchor 1.0
         parallel:
              ease 1.0 xpos 0.75
         parallel:
              ease 1.0 zoom 1.0
         parallel:
              ease 0.3 alpha 1.0
         parallel:
              ease 0.3 yanchor 0.98
              ease 0.3 yanchor 1.0
              repeat

    pause 0.8

    show john a_15:
         faceleft
         ease 0.7 xpos 0.5

    pause 0.7

    show john a_15:
         xpos 0.5
         zoom 1.0
         alpha 1.0


    "I flew down the stairs so fast that I might as well have been falling. At first I still couldn't see where the device had come to rest, but as soon as I turned past the landing I found it lying just a few stairs from the bottom of the stairwell."

    stop music fadeout 4.0

    show john a_2 with exchange
    "As soon as I finally had the device back in hand, though, I knew something was wrong."

    "The device made a rattling sound as I turned it over in my hand, like something had come loose inside of it. Worse, as I turned it away from the sunlight, I could see a small, dim light on the device had begun flickering."

    "Cautiously, I tried pressing a button on the device, but nothing changed. No sound, no light, no click."

    "I tried another. Still nothing. Then another. And another." #possibly want to do the line pause/extend deal between the sentences here

    scene black
    with HorizCenterTransition(0.25, True)

    "I let out an exasperated sigh and closed my eyes, feeling my stomach sink as the air escaped my lungs."

    think "Did I really just turn the most advanced piece of technology on the face of the earth into a paperweight?"

    scene bg school stairwell_1 day
    show john a_2 at center, faceleft
    with HorizCenterTransition(1.0, False)

    "I opened my eyes again, hoping by some miracle that they would see something different this time."

    "All I got was the same flickering light on the same broken device."

    john "...Damn it."

    "Behind me, I heard the sound of light footsteps descending down the stairs. As soon as they stopped, I heard a voice call out."

    show yui a_6 at right, faceleft with easeinright
    yui "John, you-- Are you alright?"

    show john a_2 at faceright with exchange
    "I turned around to see Yui standing at the top of the landing. Her hair was still disheveled after her near-fall, and her face still carried a look of concern."

    show john a_6 with exchange
    "I let out a breath and gave a weak smile in response, in part to try and calm her nerves--if not my own."

    john "I feel like that's what I'm supposed to be asking {i}you{/i} right now."

    show yui a_13 with exchange
    yui "Oh! Um, I'm okay, thank you... That could have been really bad."

    think "{q}Could have been{/q}..."

    show john a_2 with exchange
    john "...Yeah."

    "I couldn't help but look down at the device as I said it."

    if fConfiscation:
        #AKA the "Oh my god I can't believe I forgot that Yui might have prior exposure to and an explanation for the device before this point" conditional
        #Let me know if this works in context or if I need to find a better solution

        show yui b_2 with exchange
        yui "Is that... your prank remote!?"

        show yui a_3 with exchange
        yui "John! I thought you would've learned better after yesterday!"

        john "I--"

        john "I'm sorry, Yui, but I lied. It wasn't a remote for a prank."

        john "It was... a lot more important than that."

        show yui a_11 with exchange
        "Yui paused for a moment, as though she was trying to process the new information she had just been given."

        show yui a_13 with exchange
        yui "I... Did you drop it when you caught me?"

        "I could see a slew of emotions cross Yui's face. What had originally looked like skepticism slowly shifted to a face of concern."

        yui "Is it broken?"

        "Yui's sympathy sapped away some of the bitterness, but I was still feeling pretty depressed about breaking something so important."

        john "...I think it's broken, yeah. Might as well be a rock at this point."

        show yui a_5 with exchange
        yui "I'm... I'm sorry, John, I didn't mean for you to..."

        show yui a_6 with exchange
        yui "You said it was important?"

    else:

        yui "Is that... yours?"

        show yui b_2 with exchange
        yui "Oh, no, did you drop it when you caught me?"

        show yui a_6 with exchange
        yui "I'm so sorry! Is it broken!?"

        john "It--"

        "Yui's obvious concern sapped away some of the bitterness, but I was still feeling pretty depressed about breaking something so important."

        john "...I think it's broken, yeah. Might as well be a rock at this point."

        show yui a_5 with exchange
        yui "Oh... Oh, no..."

        show yui a_6 with exchange
        yui "I'm not sure what your remote is for, but... was it important?"

    show john a_5 with exchange
    john "...Yeah. Yeah, it was pretty important."

    yui "I--"

    show yui a_5 with exchange
    yui "I'm sorry, John."

    "She sounded almost as bad as I felt, which helped wash away just a little bit more of my anger."

    show john a_6 with exchange
    john "Yui, don't worry about it."

    "I gave her a smile as I spoke. It was maybe a little forced, but only a little."

    john "It was you or it, and you are {i}more{/i} important."

    show john a_0 with exchange
    john "Catching you was the right choice."

    show yui a_13 blush with exchange
    "She stared at me a moment, a light flush on her cheeks."

    yui "Y--Yeah, thanks. But still, if it wasn't for me--"

    show john a_5 #would love to use a version of this sprite with his mouth open here, if we have it in our larger expressionset
    john "Yui, really, don't worry about it!"

    show john a_2 with exchange
    think "I can worry about it enough for both of us."

    show yui a_5 with exchange
    "Then again, I could see she was still sad, so I tried to think of a way to cheer her up."

    show john a_6 with exchange
    "It came to me when I remembered something that had happened when we were little."

    show john a_10 with exchange
    john "Really, it's just like that time when we were kids!"

    show yui a_12 with exchange
    yui "Huh?"

    play music bgm_i_can_hear_you fadein 8.0

    show yui a_13 with exchange
    yui "Wait, do you mean--"

    show john a_6 with exchange
    john "When we went to the park that one time, and it rained while we were there, so we hid--"

    show yui b_6 with exchange
    yui "In the tunnel on the playground until it blew over! But then I wanted to go for a walk..."

    show john a_0 with exchange
    john "Yeah, so we went walking around the pond."

    yui "...And then you slipped on the rock!"

    show john a_1 with exchange
    john "Right! And you tried to grab me before I fell, but..."

    show yui b_0 with exchange
    yui "I was not {i}nearly{/i} as successful as you were today."

    john "...Yeah."

    show yui b_8 with exchange
    "We both laughed at the memory of us ending up in the pond, soaking wet and a little bit muddy."

    show john a_10 with exchange
    john "Remember how you thought there were minnows swimming around in your shoes?"

    show yui a_6 with exchange
    yui "There {i}were!{/i} I could feel them, John!"

    show john a_13 with exchange
    john "C'mon, Yui, that was just the water in your socks and you know it."

    show yui a_1 with exchange
    "Yui laughed again, and I could tell the memory had cheered her up."

    "It had cheered me up a bit, too."

    show john a_0 with exchange
    john "I prefer it this way, though. Stairs are a bit more dangerous than some mud."

    show yui a_0 with exchange
    yui "Yeah. I could have been hurt if you hadn't been so quick..."

    "We stood in a comfortable little silence for a moment before Yui spoke up again."

    show yui a_8 with exchange
    yui "You know... we don't really spend time together like we used to."

    show john a_6 with exchange
    think "Well, you stopped coming over to my house as much..."

    yui "We should, though. We used to be such good friends..."

    "She sounded a bit wistful, and I remembered how much fun she'd always seem to have when she visited."

    show john a_0 with exchange
    john "Yeah. It wouldn't be bad to catch up more."

    stop music fadeout 8.0

    john "Do you maybe want to go grab some food after school sometime?"

    show yui b_6 with exchange
    yui "Yeah! I can't make it tonight, but that's... You probably didn't mean so soon, anyway."

    show yui a_0 with exchange
    yui "Um, I have Student Council stuff most days, but it takes longer sometimes."

    yui "Maybe..."

    show john a_5 with exchange
    "Yui started trying to schedule, which was a little more formal than I had intended my invitation, but I was distracted by a warm sensation in my hand--the hand holding the broken device."

    show yui a_13 with exchange
    yui "Oh, but that won't work, because I have to work on the budget for--"

    show john a_4 with exchange
    "It quickly went from warm to hot, then to burning."

    john "Oh shit!"

    show yui b_2 with exchange
    "My shout interrupted Yui as a spike of burning pain ran up my arm and I reflexively opened my hand--"

    "--Dropping the device on the ground!"

    scene bg school stairwell_1 day
    show john a_9 at center, faceright
    show yui b_3 at right, faceleft
    with Fade(.25, 0, .75, color="#fff")

    "There was an eye-searing flash, and I had to blink spots out of my eyes."

    show john a_5 with exchange
    show yui b_9 with exchange
    "When my vision recovered, I was relieved to see myself in my own body, and nothing strange happening to Yui, either."

    think "...I didn't really {i}expect{/i} anything, but who knows what could have happened?"

    think "I really don't want both of us getting turned into Zoey."

    yui "...John?"

    "Yui sounded a bit dazed. More so than I had been, anyway."

    yui "What {i}was{/i} that?"

    show john a_15 with exchange
    john "Uh--"

    think "Think of a good lie that isn't about the alien device you brought to school..."

    show john a_6 with exchange
    john "I think... Maybe it was broken more than I thought, and one of the batteries short circuited?"

    show yui a_13 with exchange
    yui "...Oh."

    yui "I guess that's why it made that flash and that weird noise."

    show john a_5 with exchange
    think "Wait, what weird noise?"

    show yui a_5 with exchange
    yui "I'm... still really sorry I broke your thing, but please don't bring anything that dangerous to school again?"

    john "Uh, yeah."

    show john a_2 with exchange
    john "I... really didn't know it would do that, or I wouldn't have brought it at all."

    show yui a_0 with exchange
    "She smiled at me, still looking a little out of it."

    yui "Of course not, I should have known. Still, please, no more."

    show yui b_10 with exchange
    show john a_5 with exchange
    yui "If you do, I might just have to punish you next time."

    show yui b_2 blush with exchange
    "She followed up her statement with a wink, before her face flushed as red as a firetruck."

    show yui a_6 blush with exchange
    yui "I--Uh--{b}I'm gonna go now!{/b}"

    show yui a_6 blush: #Need to figure out animation for this #Chori: Done~
        faceright
        pause 0.5
        ease 0.3 xpos 2.0

    "She must've realized just how suggestive her joke sounded as soon as she said it, because she vanished before I could even muster a response."

    hide yui
    show john a_6 with exchange
    think "Well... at least she's learning. That would've gone straight over her head even a few years ago."
    #or a few minutes ago
    #*seconds ago

    show john a_5 with exchange
    "Now that I found myself alone again, my attention drifted back to the device sitting at my feet. I cautiously hovered my hand over it, trying to gauge if it was still warm."

    "Feeling nothing, I outstretched my index finger and gave it a light touch."

    think "... Huh, just as cool as it was before."

    "Still with a bit of discretion, I gripped the device in my hand. I didn't feel anything out of the ordinary as I picked it up, but the rattling noise was definitely still there."

    "After some further observation, I noticed that the light that had previously been flickering was now completely dark. Whatever life the device previously still had left was officially gone."

    think "I guess I actually wasn't too far off the mark with my explanation to Yui, then. Still, I should find somewhere to put this just in case it decides to go nuclear again."

    scene bg school lockers day
    with dissolve

    "Of course, now that I was back on the first floor it wasn't a far trip to my locker. A few minutes later and I had the broken device stored away for safe keeping."

    play sound sfx_bell

    "As if right on cue, the bell rang to mark the end of the lunch period. For a brief moment I worried about needing to catch Zoey before she went too far, only to remember that none of it really mattered any more."

    "Whether I liked it or not, I suddenly found myself right back in my regular old life. No aliens, no otherworldly devices, no unexplainable powers. All that was left was to carry out the rest of my school day like all the other ones before it."

    "The hall began to fill with a stream of students as they headed to their next classes, and I found myself following suit."

    scene bg school classroom_3 day
    with fade

    "The day proceeded normally afterwards. Unfortunately Mallory's class proceeded normally, too. My only reprieve today was the fact he wasn't giving a long lecture. He peppered me with a few questions early on, but he moved on from his brief lecture to the small group project we had to work on."

    "Unfortunately, just about everybody knew that partnering with me for any of Mallory's projects was a GPA death wish. As usual, I found myself waiting for whoever would be left over once everyone else had paired off."

    if fConfiscation:

        "For a moment I actually thought that Michelle might have been willing to bite the bullet, but after looking my way a few times she seemed to lose interest and matched with another partner instead."

    "Sure enough, Brad was the one to eventually come to the rescue. I knew his grade in this class already wasn't great, but it still took a brave soul to voluntarily suffer alongside me."

    play music bgm_pyro_flow
    show brad a_0 at centerleft
    show john a_8 at centerright, faceleft
    with dissolve

    john "Thanks for doing this. I'd be stuck trying to finish it alone otherwise."

    brad "Not a problem, man. Besides, my grade in this class can't get that much worse than it already is."

    show john a_2 with exchange
    john "It's that bad?"

    show brad a_5 with exchange
    brad "Let's just say I won't be a history major when I get out of here."

    show john a_13 with exchange
    john "What, did Mallory not open your eyes to the {i}fun{/i} of history?"

    show brad a_1 with exchange
    brad "If he {q}opened my eyes{/q} to anything, it's how nice it is to not have to bother studying for an entire class."

    show brad a_0 with exchange
    brad "Really, man, I don't think I've ever had as much free time as I do these days. It's great."

    show john a_0 with exchange
    john "With how many teams you're on, I'm surprised you had any free time in the first place."

    show brad a_7 with exchange
    brad "Nah, they do a good job of making sure we get time outside of school. I'm pretty sure the guys would riot if they ever started stacking more practices on us. At least, their girlfriends definitely would."

    show brad a_0 with exchange
    brad "Meanwhile, I'm out here living the life of a free man. It's good to be out of the dating scene for a bit, you know?"

    show john a_13 with exchange
    john "I'm not sure I can relate, considering I've never really been {i}in{/i} the dating scene."

    "I only said it as a bit of a joke at my own expense, but Brad seemed more than ready to take it as his cue."

    show brad a_1 with exchange
    brad "Ah, come on! We can fix that in like a day, tops. You're a good guy, I'm sure there's plenty of girls who would be more than interested."

    show brad a_0 with exchange
    brad "Hell, if you're worried about breaking the ice, let me be your wingman."

    show john a_10 with exchange
    "I laughed, but I didn't plan on humoring him."

    john "We'll have to save it for another time. We really should be starting on this project, at least if we want any chance at getting a passing grade."

    show brad a_7 with exchange
    show john a_0 with exchange
    brad "Man, I know you're just trying to walk your way out of this."

    brad "...But, you're probably right."

    stop music fadeout 2.0

    hide john
    hide brad
    with dissolve

    "Once we dialed back down, we finally started working to play catch-up on our project. It was on the French Revolution yet again, focusing on the period of the Directory. By the end of the class, I was feeling relatively confident on the topic, as much good as it'd do me."

    scene bg school hallway_1 day
    with fade

    "We left class together, saying our goodbyes as we went our separate ways. Before I had gone too far, though, Brad turned back to give me a few parting words from down the hall."

    show brad a_1 at centerleft
    with dissolve

    brad "Like I said--Wingman!"

    hide brad
    with dissolve

    "I rolled my eyes and continued towards my locker."

    scene bg school lockers day
    with fade

    "The broken device was the very first thing to greet me, and I found myself brought right back to my previous dour mood."

    "I didn't expect anything to have changed, but I still found myself checking the small light on the device for any signs of life. As expected, it was still just as dead as I had left it."

    "Still, I wasn't going to have a chance to really look at it here: I'd need to get it home so I could give it a proper looking over."

    "I ended up gathering it along with what I needed for the day's homework and left the school."

    scene bg school entrance day
    show katrina a_14 at centerleft
    with dissolve
    #Chori: Reminder to ask about adding a_18 to the core files.
    #Iwana: Done, expression is now a_14

    "At the front entrance, I saw Katrina waiting just beyond the main gate. Normally she'd be long gone by now, but for some reason she was still sticking around today."

    show john a_0 at centerright, faceleft with dissolve
    john "Hey, what are you still doing here?"

    show katrina a_4 with exchange
    katrina "Oh, John! I wanted to talk with you about something after lunch, but you never came back."

    "Her face actually looked more serious than I was expecting, and as soon as I thought about it I had a feeling I knew what this was about."

    show john a_2 with exchange
    john "Oh, do you mean about Kyoko? I'm sorry, I shouldn't have left you two alone when I did. I was really hoping I'd run into her before she went home today to see if she was feeling any better."

    play music bgm_marty_gots_a_plan

    show katrina a_14 #Chori: Maybe too much surprise?
    "Unexpectedly, the expression on Katrina's face shifted to surprise."

    katrina "Um, that's actually not what... You're okay, no need to apologize."

    show john a_6 with exchange
    john "Whew, for a second there I thought you were about to grill me. I'm sorry, today's just been... a really rough day, all in all."

    show katrina b_2 with exchange
    katrina "Honestly? I've been feeling a bit out of it today too. No focus at all in the last few classes. What's got you worked up, though?"

    "I was tempted to say something about the device, but I knew Kat would just think it was part of another of Kiyoshi's harebrained plots. Especially now that it was no more a functional alien device than that old can of cat food Kiyoshi presented to us as {q}alien tech{/q} last time."

    "Instead, I tried to keep it vague without raising more questions, deflecting to the rest of the day's events."

    if fConnieCheat:
        show john a_5 with exchange
        john "I... Well, I wasted a pretty good opportunity earlier today. And then on top of that you had the deal with Kyoko, Mallory gave us that group project that's almost definitely going down as another 'F'--"

        show katrina a_1 with exchange
        katrina "And let me guess: You're finally realizing that {i}Dank Souls{/i} study technique for the math test might not have been as foolproof as you thought."

    else:
        show john a_5 with exchange
        john "I... Well, I wasted a pretty good opportunity earlier today. And then on top of that there was the deal with Kyoko, I almost definitely bombed Ms. William's math test, and Mallory gave us that group project so that's just another 'F' to add to the pile."

        show katrina a_5 with exchange
        katrina "Well, I'd say most of that is par for the course. If Mallory {i}wasn't{/i} a complete ass today, that's when I'd really start worrying."

    show john a_6 with exchange
    john "Haha, yeah. It's just hard to be in a good mood today, is all."

    show katrina b_1 with exchange
    katrina "Why don't you come with me back to my place, then? We could make it a date!"

    show john a_10 with exchange
    "I chuckled, but unfortunately all I wanted to do right now was get home and take another look at the device."

    show john a_13 with exchange
    john "I'd love to, Kat, but I really don't think I'm feeling up for it right now. Sorry."

    show katrina b_0 with exchange
    show john a_6 with exchange
    katrina "You sure? I can think of a {i}whole lot{/i} of things we could do there..."

    katrina "{i}And{/i} my mom and sisters should be out pretty much all night..."

    "She wiggled her eyebrows up and down for emphasis, but I knew better by now than to let myself get flustered by such an obvious teasing attempt."

    john "Har har, very funny Kat."

    show katrina a_5 with exchange
    katrina "I'm serious!"

    katrina "Come on John, I still have that crazy idol costume Kiyoshi dumped on me for my birthday sitting in the closet. You could help me finally try it on~"

    show katrina a_1 with exchange
    katrina "Or {i}take it off~{/i}"

    katrina "...And think about all of the fun {i}that{/i} could lead to."

    show john a_2 blush with exchange
    "I knew she was just trying to screw with me--bringing up that cosplay Kiyoshi had for god knows what reason was more than enough of a tip-off--but that still did nothing to stop the feeling of heat starting to rise in my cheeks."

    "My best defense left was to simply roll my eyes, deflect, and disengage; a routine I had become more than accustomed to over the years."

    show john a_10 blush with exchange
    john "We'll have to do a rain check on that one. I'll have my people call your people."

    show katrina b_2 with exchange
    "Kat pantomimed like she had deflated a bit, giving me a bit of a disappointed look."

    stop music fadeout 8.0

    katrina "So that's a {q}no,{/q} then?"

    show john a_6 with exchange
    john "That's an {q}I'd rather go home and sleep off an awful day,{/q} as much fun as it'd be to hang out."

    john "We'll get everyone together for another D&D night soon, though, don't worry."

    show john a_0 with exchange
    john "Anyways, gonna head for home. See you tomorrow?"

    show katrina b_6 with exchange
    katrina "...Yeah, same. See you tomorrow."

    "I gave Kat a parting wave as I finally left the school gates behind."

    #transitions!
    scene bg neighborhood_2 day
    with dissolve

    play music bgm_comfortable_mystery

    nvl clear
    nvl_narrator "The walk home was fairly uneventful, buildings and streets blurring from one into another."

    nvl_narrator "As my mind drifted again and again to what had happened with the device, I found my feet beginning to drag a bit. I was doing my best not to think about it, but truthfully I couldn't help it."

    nvl_narrator "Most of my thoughts were {q}what if's,{/q} in everything from my actions during lunch to all the way back on my very first morning with the device. Countless opportunities to use the device, to have told someone about it, and I mostly sat on my hands for the past few days."

    nvl_narrator "Was I worried about what might happen? In retrospect it felt like I wasted so much time that I could have been using the device, but at the time it felt like I still had a lifetime to find the right opportunity."

    nvl_narrator "And of course, the one opportunity I {i}did{/i} decide on was the one that turned the device into a brick."

    nvl_narrator "Of course, I knew better than to fall for that line of thinking. I very well could have lost the device on the first day I had it, or I could have broken it in any number of circumstances. I had no idea what {i}could have{/i} or {i}would have{/i} happened if I had done things differently."

    nvl_narrator "Still, that didn't do anything to stop those thoughts from bubbling up in the first place."

    play sound [sfx_door_open, sfx_door_close]
    scene bg house_davis livingroom dusk
    with dissolve

    "When I finally made it home, I opened the front door to what appeared to be an empty house. After a few moments and a trip to the fridge, though, I could hear movement coming from up the stairs."

    "If I had to venture a guess, it was likely mom changing out of her work clothes upstairs. She didn't often beat me home, but I obviously wasn't in much of a hurry to get home today."

    think "I suppose I lucked out--Mom can always tell when I'm out of it, and the last thing I want to do right now is have to come up with an excuse."

    "Instead, I slinked away to my bedroom, closing the door behind me."

    scene bg house_davis bedroom_john dusk
    with fade

    play sound sfx_door_close

    #Goopy note: add in a small bit here of John opening up the device and at least thinking about the potential of repairing it

    "I found myself simply standing at the entry of my room in a state of enervation, backpack still weighing on my shoulder."
    #It is now canon: John one-straps

    "As much as I had wanted to get home, look over the device again... Well, now that I was actually {i}here,{/i} it was like my drive had been completely sapped. Just the thought of pulling the device out again felt like a Herculean task."

    "Still, I knew it couldn't be helped. If there was even a chance it might still be functional, I had to know for sure."

    "Dragging myself forward through my paralyzed state, I plopped my backpack down at the foot of my bed and reached inside for the device."

    "As I brought it up I gave it a bit of a shake, the now-familiar rattle greeting me in response. Turning it over, the small indicator light was still dead as well, just like I had left it."

    "At the very least, I knew now that giving it a few hours to recharge had made no difference."

    "My next option was to see if there was any way I could reasonably open the device. I knew it was a long shot, but if something had come loose inside of it, maybe it could be put back into place?"

    "I gave the exterior of the device a thorough examination, looking somewhere for any kind of seam or latch. Unfortunately, beyond a few scuffs and the placements for the buttons and lights, the device's surface was completely featureless, smooth and seamless to an almost unsettling degree."

    "In desperation, I tried pulling up and underneath from one of the buttons, hoping at the very least for a way to see into the interior of the device."

    stop music fadeout 6.0

    "Of course, it was hopeless."

    think "What was I expecting, anyways? That I was going to casually open a piece of alien technology, plug in a loose wire here or shift around a circuit there, and boom, I'd be right back to operational?"

    think "I mean, how am I supposed to even know what alien tech {b}looks{/b} like? For all I know I could've opened it only to have some glitter and beads spill out."

    think "It'd be stupid to just expect the inside to look like a TV remote, wouldn't it?"

    "I found myself equal parts frustrated and demoralized, coming to the full realization that I was in way over my head here."

    "I stared at the device in silence for a few moments, not quite sure what to even do with it any more."

    #Note for anybody who wants to help me think about it: the new goal is to figure out how to transition from here through dinner and into the night. Video games was the original easy path, but connecting A to Z seamlessly here is something I need to think more about

    "My hand eventually dropped to my side before I simply let myself fall backwards onto my bed. I landed with a soft thud beside my backpack, eyes now fixed on the ceiling above me."

    "I gave myself a few more minutes here, quietly lying under the glow of the setting sun. I watched as the shadows slowly creeped their way further and further along the walls, listened to the faint clanking of pots from below as my mom prepared dinner."

    "It was easy to stay in this moment, if only because I didn't want to think about what came before or after."

    "When I finally did muster the energy to sit up from my temporary sepulchre, it almost felt like I was crossing back over a threshold that I had only just broken."

    "It was official: I was right back to my regular, ordinary life."

    "Of course, my regular ordinary life usually didn't revolve around me sitting on my bed and staring at a wall."

    think "If I hadn't ever gotten the device, what would I be doing right now instead?"

    think "..."

    think "...Playing Dank Souls, easy."

    "Now that the thought had crept up, I actually couldn't help but feel like playing video games for a bit actually wouldn't be the worst thing in the world. There was something appealing about being able to put my mind off of the past few days, at least."

    "Seeking my ever-too-familiar refuge, I flipped on the TV and grabbed my controller."

    "Before long, and after dealing a few repeated blows to the usual mobs, the pit in my gut finally started to fade away. Getting back into the routine and rhythm, returning to what I had done for countless hours before today, made it all too easy to focus in on what I was doing in the moment. The minutes flew by, and I found myself returning to normalcy again."

    "In fact, if I hadn't had to set the controller aside for dinner, I probably could have made it straight through a gaming mini-marathon."

    scene bg house_davis bedroom_john night
    with fade

    "When I returned to my bedroom for the night, I was immediately greeted by my backpack and the device, still lying in their temporary graveyard on my bed."

    "With nothing better left to do, I picked up the device one last time to find it a proper resting place."

    "This time, though, I found that despite the indescribable wasted opportunity that was currently sitting in my hands, I actually didn't feel all too upset right now. The pit in my stomach wasn't returning, there wasn't the same sense of unease..."

    "It just felt... normal. Inevitable. Like this was expected."

    "{b}Did{/b} I expect this? I had always wanted something extraordinary to happen, to break up the humdrum routine of everyday life, but when it finally {b}did{/b} come it was like I couldn't make the jump."

    "Why?"

    "At first my inaction seemed tepid or overly cautious at best, but as I thought about it more I came to a realization."

    play music bgm_snowfall fadein 12.0

    "For all the {q}what if's{/q} I had gone through on the walk home today, none of them had actually been about what I would have {i}done{/i} with the device."

    if fConnieCheat:

        think "Sure, I got to use it to cheat on a math test, but... was that really the extent of my aspirations?"

    else:

        think "I mean, I didn't even end up using it to get a better grade on a math test, much less swap {b}lives{/b} with someone."

    "Maybe I really was just... ordinary."

    "Even when I felt like I wanted something more, when the opportunity actually presented itself I simply chose the status quo instead."

    "It made sense. I was actually pretty content with where I was in life--a good family, a nice house, great friends. I had alright grades and was on track to graduate, get into college, and then get a decent job somewhere if I didn't screw up."

    "I was, well, happy. Sure, there were some of the small things I'd probably change if given the chance, but on the whole I didn't imagine myself living a different life, being a different person."

    "Maybe I was just the wrong person to have a device like this."

    "Maybe living an average life from this point forward wasn't such a bad thing after all."

    "...Or maybe I was just trying to convince myself."

    "With those last thoughts, I put the broken device away in my desk drawer and started winding down for the night."
    #JC note: tweak this ending monologue a bit to fall a bit better in line with core Day 4
    #ahaha nevermind suck it jc!!!!1!!1!
    #Okay, let's see if this rendition backs up what I had originally been aiming for a bit better: John at the end of this day should be a very different John than the one who ends on Skeleton Day 4. Day 4 John still has the world open to him, still feels like using the device is simply "inevitable." This John has to come to terms that, well, no, that window is closed. He has to be able to answer /why/ he didn't use the device, and the best answer he can arrive at for closure is "Even if I told myself that I wanted more, even if I said I wanted the extraordinary, when it was handed to me on a silver platter I could never make myself make the jump. Maybe that means I'm just ordinary after all." It echoes a bit of the game's opening monologue as well, and truthfully I feel like it arrives at the note I wanted to hit for the end of this night, namely being "If things ended right here, you could accept this as an ending for John's character."

    stop music fadeout 2.0
    scene black
    with HorizCenterTransition(2.0, True)
    pause 2.0

    jump legacy_alien_mariamania_day5
